unit AlcinoeParserTest;

interface

uses
  Windows,
  Classes,
  SysUtils,
  i_Timer,
  ALXmlDoc,
  ALStringList;

{.$DEFINE VERB_SAX_MODE}

type
  TAlcinoeXMLTester = class
  private
    {$IFDEF VERB_SAX_MODE}
    procedure ParseStartElement(Sender: TObject; const Path, Name: AnsiString; const Attributes: TALStrings);
    procedure ParseProcessingInstruction(Sender: TObject; const Path, Target, Data: AnsiString);
    procedure ParseText(Sender: TObject; const Path, Str: AnsiString);
    procedure ParseComment(Sender: TObject; const Path, Str: AnsiString);
    {$ENDIF}
  public
    procedure TestIt(const AStream: TStream; const ATimer: ITimer);
  end;

implementation

procedure TAlcinoeXMLTester.TestIt(const AStream: TStream; const ATimer: ITimer);
var
  VXml: TAlXmlDocument;
  VStartTime, VFinishTime: Int64;
begin
  VXml := TALXmlDocument.create('root');
  try
    {$IFDEF VERB_SAX_MODE}
    VXml.OnParseStartElement := ParseStartElement;
    VXml.OnParseProcessingInstruction := ParseProcessingInstruction;
    VXml.OnParseText := ParseText;
    VXml.OnParseComment := ParseComment;
    {$ENDIF}

    AStream.Position := 0;

    VStartTime := ATimer.CurrentTime;
    VXml.LoadFromStream(AStream, True);
    VFinishTime := ATimer.CurrentTime;

    Writeln(Format('Alcinoe in SAX mode: %.8f sec.', [(VFinishTime - VStartTime)/ATimer.Freq]));

    AStream.Position := 0;
    VXml.Clear('root');

    VStartTime := ATimer.CurrentTime;
    VXml.LoadFromStream(AStream, False);
    VFinishTime := ATimer.CurrentTime;

    Writeln(Format('Alcinoe in DOM mode: %.8f sec.', [(VFinishTime - VStartTime)/ATimer.Freq]));
  finally
    VXml.Free;
  end;
end;

{$IFDEF VERB_SAX_MODE}
procedure TAlcinoeXMLTester.ParseStartElement(Sender: TObject; const Path, Name: AnsiString; const Attributes: TALStrings);
var
  I: Integer;
begin
  Writeln(Format('StartElement >> Path: "%s" | Name: "%s" | Attributes Count: %d', [Path, Name, Attributes.Count]));
  for I := 0 to Attributes.Count - 1 do begin
    Writeln(Format('    Attr #%d: %s', [I+1, Attributes[I]]));
  end;
end;

procedure TAlcinoeXMLTester.ParseProcessingInstruction(Sender: TObject; const Path, Target, Data: AnsiString);
begin
  Writeln(Format('ProcessingInstruction >> Path: "%s" | Target: "%s" | Data: "%s"', [Path, Target, Data]));
end;

procedure TAlcinoeXMLTester.ParseText(Sender: TObject; const Path, Str: AnsiString);
begin
  Writeln(Format('Text >> Path: "%s" | Str: "%s"', [Path, Str]));
end;

procedure TAlcinoeXMLTester.ParseComment(Sender: TObject; const Path, Str: AnsiString);
begin
  Writeln(Format('Comment >> Path: "%s" | Str: "%s"', [Path, Str]));
end;
{$ENDIF}

end.
