﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using System.Data.SQLite;

namespace Mapv4v5Converter
{
    public partial class SelectLocaleDlg : Form
    {
        string[,] languages;
        string[,] regions;
        public SelectLocaleDlg()
        {
            InitializeComponent();
            languages = new string[,] {
            {"Arabic","ar"},
            {"British English","en-GB"},
            {"Catalan","ca"},
            {"Chinese Simplified","zh-Hans"},
            {"Chinese Traditional","zh-Hant"},
            {"Croatian","hr"},
            {"Czech","cs"},
            {"Dansk","da"},
            {"Deutsch","de"},
            {"English","en"},
            {"Español","es"},
            {"Français","fr"},
            {"Greek","el"},
            {"Hebrew","he"},
            {"Hungarian","hu"},
            {"Indonesian","id"},
            {"Italiano","it"},
            {"Japanese","ja"},
            {"Korean","ko"},
            {"Malay","ms"},
            {"Nederlands","nl"},
            {"Norsk (Bokmål)","nb"},
            {"Polski","pl"},
            {"Português (Portugal)","pt-PT"},
            {"Português","pt"},
            {"Pусский","ru"},
            {"Romanian","ro"},
            {"Slovak","sk"},
            {"Suomi","fi"},
            {"Svensk","sv"},
            {"Thai","th"},
            {"Turkish","tr"},
            {"Ukrainian","uk"},
            {"Vietnamese","vi"},
            };
            for (int i = 0; i < languages.GetLength(0); i++)
            {
                languageField.Items.Add(languages[i, 0]);
            }
            regions = new string[,]{
{"AFGHANISTAN"	 ,"AF"},
{"ALAND ISLANDS"	 ,"AX"},
{"ALBANIA"	 ,"AL"},
{"ALGERIA"	 ,"DZ"},
{"AMERICAN SAMOA"	 ,"AS"},
{"ANDORRA"	 ,"AD"},
{"ANGOLA"	 ,"AO"},
{"ANGUILLA"	 ,"AI"},
{"ANTARCTICA"	 ,"AQ"},
{"ANTIGUA AND BARBUDA"	 ,"AG"},
{"ARGENTINA"	 ,"AR"},
{"ARMENIA"	 ,"AM"},
{"ARUBA"	 ,"AW"},
{"AUSTRALIA"	 ,"AU"},
{"AUSTRIA"	 ,"AT"},
{"AZERBAIJAN"	 ,"AZ"},
{"BAHAMAS"	 ,"BS"},
{"BAHRAIN"	 ,"BH"},
{"BANGLADESH"	 ,"BD"},
{"BARBADOS"	 ,"BB"},
{"BELARUS"	 ,"BY"},
{"BELGIUM"	 ,"BE"},
{"BELIZE"	 ,"BZ"},
{"BENIN"	 ,"BJ"},
{"BERMUDA"	 ,"BM"},
{"BHUTAN"	 ,"BT"},
{"BOLIVIA, PLURINATIONAL STATE OF"	 ,"BO"},
{"BOSNIA AND HERZEGOVINA"	 ,"BA"},
{"BOTSWANA"	 ,"BW"},
{"BOUVET ISLAND"	 ,"BV"},
{"BRAZIL"	 ,"BR"},
{"BRITISH INDIAN OCEAN TERRITORY"	 ,"IO"},
{"BRUNEI DARUSSALAM"	 ,"BN"},
{"BULGARIA"	 ,"BG"},
{"BURKINA FASO"	 ,"BF"},
{"BURUNDI"	 ,"BI"},
{"CAMBODIA"	 ,"KH"},
{"CAMEROON"	 ,"CM"},
{"CANADA"	 ,"CA"},
{"CAPE VERDE"	 ,"CV"},
{"CAYMAN ISLANDS"	 ,"KY"},
{"CENTRAL AFRICAN REPUBLIC"	 ,"CF"},
{"CHAD"	 ,"TD"},
{"CHILE"	 ,"CL"},
{"CHINA"	 ,"CN"},
{"CHRISTMAS ISLAND"	 ,"CX"},
{"COCOS (KEELING) ISLANDS"	 ,"CC"},
{"COLOMBIA"	 ,"CO"},
{"COMOROS"	 ,"KM"},
{"CONGO"	 ,"CG"},
{"CONGO, THE DEMOCRATIC REPUBLIC OF THE"	 ,"CD"},
{"COOK ISLANDS"	 ,"CK"},
{"COSTA RICA"	 ,"CR"},
{"COTE D'IVOIRE"	 ,"CI"},
{"CROATIA"	 ,"HR"},
{"CUBA"	 ,"CU"},
{"CYPRUS"	 ,"CY"},
{"CZECH REPUBLIC"	 ,"CZ"},
{"DENMARK"	 ,"DK"},
{"DJIBOUTI"	 ,"DJ"},
{"DOMINICA"	 ,"DM"},
{"DOMINICAN REPUBLIC"	 ,"DO"},
{"ECUADOR"	 ,"EC"},
{"EGYPT"	 ,"EG"},
{"EL SALVADOR"	 ,"SV"},
{"EQUATORIAL GUINEA"	 ,"GQ"},
{"ERITREA"	 ,"ER"},
{"ESTONIA"	 ,"EE"},
{"ETHIOPIA"	 ,"ET"},
{"FALKLAND ISLANDS (MALVINAS)"	 ,"FK"},
{"FAROE ISLANDS"	 ,"FO"},
{"FIJI"	 ,"FJ"},
{"FINLAND"	 ,"FI"},
{"FRANCE"	 ,"FR"},
{"FRENCH GUIANA"	 ,"GF"},
{"FRENCH POLYNESIA"	 ,"PF"},
{"FRENCH SOUTHERN TERRITORIES"	 ,"TF"},
{"GABON"	 ,"GA"},
{"GAMBIA"	 ,"GM"},
{"GEORGIA"	 ,"GE"},
{"GERMANY"	 ,"DE"},
{"GHANA"	 ,"GH"},
{"GIBRALTAR"	 ,"GI"},
{"GREECE"	 ,"GR"},
{"GREENLAND"	 ,"GL"},
{"GRENADA"	 ,"GD"},
{"GUADELOUPE"	 ,"GP"},
{"GUAM"	 ,"GU"},
{"GUATEMALA"	 ,"GT"},
{"GUERNSEY"	 ,"GG"},
{"GUINEA"	 ,"GN"},
{"GUINEA-BISSAU"	 ,"GW"},
{"GUYANA"	 ,"GY"},
{"HAITI"	 ,"HT"},
{"HEARD ISLAND AND MCDONALD ISLANDS"	 ,"HM"},
{"HOLY SEE (VATICAN CITY STATE)"	 ,"VA"},
{"HONDURAS"	 ,"HN"},
{"HONG KONG"	 ,"HK"},
{"HUNGARY"	 ,"HU"},
{"ICELAND"	 ,"IS"},
{"INDIA"	 ,"IN"},
{"INDONESIA"	 ,"ID"},
{"IRAN, ISLAMIC REPUBLIC OF"	 ,"IR"},
{"IRAQ"	 ,"IQ"},
{"IRELAND"	 ,"IE"},
{"ISLE OF MAN"	 ,"IM"},
{"ISRAEL"	 ,"IL"},
{"ITALY"	 ,"IT"},
{"JAMAICA"	 ,"JM"},
{"JAPAN"	 ,"JP"},
{"JERSEY"	 ,"JE"},
{"JORDAN"	 ,"JO"},
{"KAZAKHSTAN"	 ,"KZ"},
{"KENYA"	 ,"KE"},
{"KIRIBATI"	 ,"KI"},
{"KOREA, DEMOCRATIC PEOPLE'S REPUBLIC OF"	 ,"KP"},
{"KOREA, REPUBLIC OF"	 ,"KR"},
{"KUWAIT"	 ,"KW"},
{"KYRGYZSTAN"	 ,"KG"},
{"LAO PEOPLE'S DEMOCRATIC REPUBLIC"	 ,"LA"},
{"LATVIA"	 ,"LV"},
{"LEBANON"	 ,"LB"},
{"LESOTHO"	 ,"LS"},
{"LIBERIA"	 ,"LR"},
{"LIBYAN ARAB JAMAHIRIYA"	 ,"LY"},
{"LIECHTENSTEIN"	 ,"LI"},
{"LITHUANIA"	 ,"LT"},
{"LUXEMBOURG"	 ,"LU"},
{"MACAO"	 ,"MO"},
{"MACEDONIA, THE FORMER YUGOSLAV REPUBLIC OF"	 ,"MK"},
{"MADAGASCAR"	 ,"MG"},
{"MALAWI"	 ,"MW"},
{"MALAYSIA"	 ,"MY"},
{"MALDIVES"	 ,"MV"},
{"MALI"	 ,"ML"},
{"MALTA"	 ,"MT"},
{"MARSHALL ISLANDS"	 ,"MH"},
{"MARTINIQUE"	 ,"MQ"},
{"MAURITANIA"	 ,"MR"},
{"MAURITIUS"	 ,"MU"},
{"MAYOTTE"	 ,"YT"},
{"MEXICO"	 ,"MX"},
{"MICRONESIA, FEDERATED STATES OF"	 ,"FM"},
{"MOLDOVA, REPUBLIC OF"	 ,"MD"},
{"MONACO"	 ,"MC"},
{"MONGOLIA"	 ,"MN"},
{"MONTENEGRO"	 ,"ME"},
{"MONTSERRAT"	 ,"MS"},
{"MOROCCO"	 ,"MA"},
{"MOZAMBIQUE"	 ,"MZ"},
{"MYANMAR"	 ,"MM"},
{"NAMIBIA"	 ,"NA"},
{"NAURU"	 ,"NR"},
{"NEPAL"	 ,"NP"},
{"NETHERLANDS"	 ,"NL"},
{"NETHERLANDS ANTILLES"	 ,"AN"},
{"NEW CALEDONIA"	 ,"NC"},
{"NEW ZEALAND"	 ,"NZ"},
{"NICARAGUA"	 ,"NI"},
{"NIGER"	 ,"NE"},
{"NIGERIA"	 ,"NG"},
{"NIUE"	 ,"NU"},
{"NORFOLK ISLAND"	 ,"NF"},
{"NORTHERN MARIANA ISLANDS"	 ,"MP"},
{"NORWAY"	 ,"NO"},
{"OMAN"	 ,"OM"},
{"PAKISTAN"	 ,"PK"},
{"PALAU"	 ,"PW"},
{"PALESTINIAN TERRITORY, OCCUPIED"	 ,"PS"},
{"PANAMA"	 ,"PA"},
{"PAPUA NEW GUINEA"	 ,"PG"},
{"PARAGUAY"	 ,"PY"},
{"PERU"	 ,"PE"},
{"PHILIPPINES"	 ,"PH"},
{"PITCAIRN"	 ,"PN"},
{"POLAND"	 ,"PL"},
{"PORTUGAL"	 ,"PT"},
{"PUERTO RICO"	 ,"PR"},
{"QATAR"	 ,"QA"},
{"REUNION"	 ,"RE"},
{"ROMANIA"	 ,"RO"},
{"RUSSIAN FEDERATION"	 ,"RU"},
{"RWANDA"	 ,"RW"},
{"SAINT BARTHELEMY"	 ,"BL"},
{"SAINT HELENA, ASCENSION AND TRISTAN DA CUNHA"	 ,"SH"},
{"SAINT KITTS AND NEVIS"	 ,"KN"},
{"SAINT LUCIA"	 ,"LC"},
{"SAINT MARTIN"	 ,"MF"},
{"SAINT PIERRE AND MIQUELON"	 ,"PM"},
{"SAINT VINCENT AND THE GRENADINES"	 ,"VC"},
{"SAMOA"	 ,"WS"},
{"SAN MARINO"	 ,"SM"},
{"SAO TOME AND PRINCIPE"	 ,"ST"},
{"SAUDI ARABIA"	 ,"SA"},
{"SENEGAL"	 ,"SN"},
{"SERBIA"	 ,"RS"},
{"SEYCHELLES"	 ,"SC"},
{"SIERRA LEONE"	 ,"SL"},
{"SINGAPORE"	 ,"SG"},
{"SLOVAKIA"	 ,"SK"},
{"SLOVENIA"	 ,"SI"},
{"SOLOMON ISLANDS"	 ,"SB"},
{"SOMALIA"	 ,"SO"},
{"SOUTH AFRICA"	 ,"ZA"},
{"SOUTH GEORGIA AND THE SOUTH SANDWICH ISLANDS"	 ,"GS"},
{"SPAIN"	 ,"ES"},
{"SRI LANKA"	 ,"LK"},
{"SUDAN"	 ,"SD"},
{"SURINAME"	 ,"SR"},
{"SVALBARD AND JAN MAYEN"	 ,"SJ"},
{"SWAZILAND"	 ,"SZ"},
{"SWEDEN"	 ,"SE"},
{"SWITZERLAND"	 ,"CH"},
{"SYRIAN ARAB REPUBLIC"	 ,"SY"},
{"TAIWAN, PROVINCE OF CHINA"	 ,"TW"},
{"TAJIKISTAN"	 ,"TJ"},
{"TANZANIA, UNITED REPUBLIC OF"	 ,"TZ"},
{"THAILAND"	 ,"TH"},
{"TIMOR-LESTE"	 ,"TL"},
{"TOGO"	 ,"TG"},
{"TOKELAU"	 ,"TK"},
{"TONGA"	 ,"TO"},
{"TRINIDAD AND TOBAGO"	 ,"TT"},
{"TUNISIA"	 ,"TN"},
{"TURKEY"	 ,"TR"},
{"TURKMENISTAN"	 ,"TM"},
{"TURKS AND CAICOS ISLANDS"	 ,"TC"},
{"TUVALU"	 ,"TV"},
{"UGANDA"	 ,"UG"},
{"UKRAINE"	 ,"UA"},
{"UNITED ARAB EMIRATES"	 ,"AE"},
{"UNITED KINGDOM"	 ,"GB"},
{"UNITED STATES"	 ,"US"},
{"UNITED STATES MINOR OUTLYING ISLANDS"	 ,"UM"},
{"URUGUAY"	 ,"UY"},
{"UZBEKISTAN"	 ,"UZ"},
{"VANUATU"	 ,"VU"},
{"VENEZUELA, BOLIVARIAN REPUBLIC OF"	 ,"VE"},
{"VIET NAM"	 ,"VN"},
{"VIRGIN ISLANDS, BRITISH"	 ,"VG"},
{"VIRGIN ISLANDS, U.S."	 ,"VI"},
{"WALLIS AND FUTUNA"	 ,"WF"},
{"WESTERN SAHARA"	 ,"EH"},
{"YEMEN"	 ,"YE"},
{"ZAMBIA"	 ,"ZM"},
{"ZIMBABWE"	 ,"ZW"},        
        };
            for (int i = 0; i < regions.GetLength(0); i++)
            {
                regionField.Items.Add(regions[i, 0]);
            }
        
        }
        public string Locale { get; set; }

        private void languageField_SelectedIndexChanged(object sender, EventArgs e)
        {
            string lang = "", reg = "";
            if (languageField.SelectedIndex >= 0)
                lang = languages[languageField.SelectedIndex, 1];
            if (regionField.SelectedIndex >= 0)
                reg = regions[regionField.SelectedIndex, 1];
            localeField.Text = lang + "_" + reg;
        }

        private void okBtn_Click(object sender, EventArgs e)
        {
            int idx = localeField.Text.IndexOf('_');
            if (idx == -1 || idx == localeField.Text.Length - 1 ||
                localeField.Text.IndexOf('_', idx + 1) != -1)
            {
                MessageBox.Show(Resource.invalidLocale, Resource.errorInCalculation, MessageBoxButtons.OK, MessageBoxIcon.Exclamation);
            }
            else
            {
                Locale = localeField.Text;
                DialogResult = DialogResult.OK;
            }
        }

        private void autoDetectBtn_Click(object sender, EventArgs e)
        {
            OpenFileDialog ofd = new OpenFileDialog();
            ofd.Filter = Mapv4v5Converter.Resource.ofdFilter1;
            ofd.Title = Resource.ofdCaption;
            if (ofd.ShowDialog() != DialogResult.OK)
                return;

            try
            {
                using (SQLiteConnection conn4 = new SQLiteConnection("Data Source=" + ofd.FileName))
                {
                    conn4.Open();
                    using (SQLiteCommand cmd = new SQLiteCommand(
                        "SELECT locale FROM version WHERE rowid=1", conn4))
                    {
                        string loc = cmd.ExecuteScalar() as string;
                        if (loc == null)
                            throw new Exception();
                        localeField.Text = loc;
                    }
                }
            }
            catch
            {
                MessageBox.Show(Resource.cantFindLocale, Resource.errorCaption, MessageBoxButtons.OK, MessageBoxIcon.Exclamation);
            }
        }
    }
}
