﻿using System;
using System.Collections.Generic;
using System.Text;
using System.Drawing;
using System.Data.SQLite;
using System.IO;

namespace Mapv4v5Converter
{
    public interface IMapWriter
    {
        void SaveTile(Bitmap image, ImgFormat format, int x, int y, int flags, int zoom);
        void Commit();
    }
    class XGpsWriter : IMapWriter
    {
        SQLiteCommand insCmd;
        SQLiteTransaction tran;
        SQLiteConnection connection;
        public XGpsWriter(string fileName)
        {
            connection = new SQLiteConnection("Data Source=" + fileName);
            connection.Open();
            tran = connection.BeginTransaction();
            insCmd = new SQLiteCommand(
                     @"INSERT INTO tiles (zoom, x, y, type, img)
                        VALUES (@zoom, @x, @y, @type, @img)", connection);
        }
        
        #region IMapWriter Members

        public void SaveTile(Bitmap image, ImgFormat format, int x, int y, int flags, int zoom)
        {
            insCmd.Parameters.Clear();
            insCmd.Parameters.AddWithValue("@x", x);
            insCmd.Parameters.AddWithValue("@y", y);
            int tp;
            if (flags == 2)
                tp = 0;
            else
                tp = 1;
            insCmd.Parameters.AddWithValue("@type", tp);
            insCmd.Parameters.AddWithValue("@zoom", 18 - zoom);
            byte[] data = Form1.ConvertToCimg(image, ImgFormat.png, 75, true);
            insCmd.Parameters.AddWithValue("@img", data);
            insCmd.ExecuteNonQuery();
        }

        public void  Commit()
        {
            tran.Commit();
            insCmd.Dispose();
            connection.Close();
        }

        #endregion
    }
    class MotionXWriter : IMapWriter
    {
        string DirName;
        public MotionXWriter(string dirName)
        {
            DirName = dirName;
        }
        #region IMapWriter Members

        public void SaveTile(Bitmap image, ImgFormat format, int x, int y, int flags, int zoom)
        {
            byte[] data = Form1.ConvertToCimg(image, ImgFormat.png, 75, true);
            int tp;
            if (flags == 2)
                tp = 20;
            else
                tp = 30;
            File.WriteAllBytes(String.Format("{0}\\{1}_{2}_{3}_{4}.data", DirName, tp, zoom - 1, x, y), data);
        }

        public void Commit()
        {
            return;
        }

        #endregion
    }
}
