﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using System.Threading;
using System.IO;
using System.Data.SQLite;
using System.Drawing.Imaging;

namespace Mapv4v5Converter
{
    public partial class FileInfoDlg : Form
    {
        public string FileName { get; set; }
        Thread thread = null;
        bool cancelThread = false;

        public FileInfoDlg()
        {
            InitializeComponent();

        }
        public enum Action
        { StartSmallCalc, StartFullCalc, StopSmallCalc, StopFullCalc, Advance }
        public delegate void AdvanceProgressCallback(Action action);
        void AdvanceProgress(Action action)
        {
            if (InvokeRequired)
            {
                AdvanceProgressCallback d = new AdvanceProgressCallback(AdvanceProgress);
                Invoke(d, new object[] { action });
            }
            else
            {
                switch (action)
                { 
                    case Action.StartSmallCalc:
                        progressBar2.Visible = true;
                        label1.Visible = true;
                        progressBar2.Maximum = 3;
                        progressBar2.Value = 0;
                        btnClose.Enabled = false;
                        break;
                    case Action.StartFullCalc:
                        button1.Enabled = false;
                        progressBar2.Visible = true;
                        label1.Visible = true;
                        progressBar2.Maximum = 3;
                        progressBar2.Value = 0;
                        btnClose.Enabled = false;
                        break;
                    case Action.StopSmallCalc:
                        progressBar2.Visible = false;
                        label1.Visible = false;
                        if (!noFullStats)
                            button1.Enabled = true;
                        btnClose.Enabled = true;
                        break;
                    case Action.StopFullCalc:
                        progressBar2.Visible = false;
                        label1.Visible = false;
                        btnClose.Enabled = true;
                        break;
                    case Action.Advance:
                        progressBar2.Value++;
                        break;
                }
            }
        }

        public delegate void UpdateLabelCallback(Control label, string text);
        void Updatelabel(Control label, string text)
        {
            if (InvokeRequired)
            {
                UpdateLabelCallback d = new UpdateLabelCallback(Updatelabel);
                Invoke(d, new object[] { label, text });
            }
            else
            {
                label.Text = text;
            }

        }
        public delegate DialogResult ShowMessagBoxCallback(string text, string caption, MessageBoxButtons btn,
    MessageBoxIcon icon);
        public DialogResult ShowMessageBox(string text, string caption, MessageBoxButtons btn, MessageBoxIcon icon)
        {
            if (InvokeRequired)
            {
                ShowMessagBoxCallback d = new ShowMessagBoxCallback(ShowMessageBox);
                return (DialogResult)Invoke(d, new object[] { text, caption, btn, icon });
            }
            else
            {
                return MessageBox.Show(text, caption, btn, icon);
            }
        }
        public delegate void UpdateListItemCallback(int row, int column, string text);
        void UpdateListItem(int row, int column, string text)
        {
            if (InvokeRequired)
            {
                UpdateListItemCallback d = new UpdateListItemCallback(UpdateListItem);
                Invoke(d, new object[] { row, column, text});
            }
            else
            {
                if (listView1.Items[row].SubItems.Count <= column)
                    listView1.Items[row].SubItems.Insert(column, new ListViewItem.ListViewSubItem());
                listView1.Items[row].SubItems[column].Text = text;
            }
        }
        bool noFullStats;
        void CalcStats()
        {
            try
            {
                AdvanceProgress(Action.StartSmallCalc);
                Updatelabel(textBox2, Resource.calculating);
                UpdateListItem(0, 0, Resource.Map);
                UpdateListItem(1, 0, Resource.Hybrid);
                UpdateListItem(2, 0, Resource.Satellite);
                for (int i = 0; i < 3; i++)
                    UpdateListItem(i, 1, Resource.calculating);
                try
                {
                    using (SQLiteConnection conn4 = new SQLiteConnection("Data Source=" + FileName))
                    {
                        conn4.Open();
                        using (SQLiteCommand cmd = new SQLiteCommand(
                        "SELECT Count(*) FROM sqlite_master WHERE type='table' AND name='tiles'", conn4))
                        {
                            if (((long)cmd.ExecuteScalar()) == 1)
                            {
                                Updatelabel(textBox2, "xGPS");
                                UpdateListItem(0, 1, "");
                                UpdateListItem(1, 1, "");
                                UpdateListItem(2, 1, "");
                                noFullStats = true;
                                return;
                            }
                        }
                        using (SQLiteCommand cmd = new SQLiteCommand(
                            "SELECT * FROM version WHERE rowid=1", conn4))
                        {
                            int ver = 0;
                            object o = cmd.ExecuteScalar();
                            if (o != null)
                                ver = (int)o;
                            switch (ver)
                            {
                                case 4:
                                    Updatelabel(textBox2, Resource.ver4);
                                    break;
                                case 5:
                                    Updatelabel(textBox2, Resource.ver5);
                                    break;
                                case 10:
                                    switch (Form1.Check10Fmt(conn4))
                                    {
                                        case Form1.mapFrmt.v10:
                                            Updatelabel(textBox2, Resource.ver10);
                                            break;
                                        case Form1.mapFrmt.v10small:
                                            Updatelabel(textBox2, Resource.ver10small);
                                            break;
                                    }
                                    break;
                                case 11:
                                    switch (Form1.Check10Fmt(conn4))
                                    {
                                        case Form1.mapFrmt.v10:
                                            Updatelabel(textBox2, Resource.ver11);
                                            break;
                                        case Form1.mapFrmt.v10small:
                                            Updatelabel(textBox2, Resource.ver11small);
                                            break;
                                    }
                                    break;
                                default:
                                    Updatelabel(textBox2, Resource.verUnknown + ver.ToString());
                                    break;
                            }
                        }
                        AdvanceProgress(Action.Advance);
                        if (cancelThread)
                            return;
                        UpdateListItem(0, 1, GetTileInfo(2, conn4));
                        AdvanceProgress(Action.Advance);
                        if (cancelThread)
                            return;
                        UpdateListItem(1, 1, GetTileInfo(3, conn4));
                        AdvanceProgress(Action.Advance);
                        if (cancelThread)
                            return;
                        UpdateListItem(2, 1,  GetTileInfo(6, conn4));
                        if (cancelThread)
                            return;

                    }
                }
                catch (Exception e)
                {
                    ShowMessageBox(e.Message, Resource.errorInCalculation,
                        MessageBoxButtons.OK, MessageBoxIcon.Exclamation);
                    Updatelabel(textBox2, "");
                    for (int i = 0; i < 3; i++)
                        for (int j = 1; j < 3; j++)
                            UpdateListItem(i, j, "");
                }
            }
            finally
            {
                AdvanceProgress(Action.StopSmallCalc);
            }
        }
        void CalcStatsFull()
        {
            try
            {
                AdvanceProgress(Action.StartFullCalc);
                for (int i = 0; i < 3; i++)
                    for (int j = 2; j < 3; j++)
                        UpdateListItem(i, j, Resource.calculating);
                try
                {
                    using (SQLiteConnection conn4 = new SQLiteConnection("Data Source=" + FileName))
                    {
                        conn4.Open();
                        using (SQLiteCommand cmd = new SQLiteCommand(
                            @"SELECT SUM(length) as len, count(*) as cnt, flags 
                                FROM images GROUP BY flags", conn4))
                        {
                            double map = -1, sat = -1, hyb = -1;
                            long mapCnt = -1, satCnt = -1, hybCnt = -1;
                            long sum = 0;
                            using (SQLiteDataReader rdr = cmd.ExecuteReader())
                            {
                                while (rdr.Read())
                                {
                                    switch ((int)rdr["flags"])
                                    {
                                        case 2:
                                            map = (long)rdr["len"];
                                            UpdateListItem(0, 2, String.Format("{0:N0}", (long)rdr["cnt"]));
                                            break;
                                        case 3:
                                            sat = (long)rdr["len"];
                                            UpdateListItem(1, 2, String.Format("{0:N0}", (long)rdr["cnt"]));
                                            break;
                                        case 6:
                                            hyb = (long)rdr["len"];
                                            UpdateListItem(2, 2, String.Format("{0:N0}", (long)rdr["cnt"]));
                                            break;
                                    }
                                    sum += (long)rdr["len"];
                                    AdvanceProgress(Action.Advance);
                                    if (cancelThread)
                                        return;
                                }
                            }
                            FileInfo fi = new FileInfo(FileName);
                            if (map != -1)
                                UpdateListItem(0, 3,
                                    String.Format(Resource.layerInfo,
                                    fi.Length * map / sum / 1024 / 1024, mapCnt)
                                    );
                            else
                            {
                                UpdateListItem(0, 2, "");
                                UpdateListItem(0, 3, "");
                            }
                            if (sat != -1)
                                UpdateListItem(1, 3,
                                    String.Format(Resource.layerInfo,
                                    fi.Length * sat / sum / 1024 / 1024, satCnt)
                                    );
                            else
                            {
                                UpdateListItem(1, 2, "");
                                UpdateListItem(1, 3, "");
                            }
                            if (hyb != -1)
                                UpdateListItem(2, 3,
                                    String.Format(Resource.layerInfo,
                                    fi.Length * hyb / sum / 1024 / 1024, hybCnt)
                                    );
                            else
                            {
                                UpdateListItem(2, 2, "");
                                UpdateListItem(2, 3, "");
                            }
                        }
                    }
                }
                catch (Exception e)
                {
                    ShowMessageBox(e.Message, Resource.errorInCalculation,
                        MessageBoxButtons.OK, MessageBoxIcon.Exclamation);
                    Updatelabel(textBox2, "");
                    for (int i = 0; i < 3; i++)
                        for (int j = 2; j < 3; j++)
                            UpdateListItem(i, j, "");
                }
            }
            finally
            {
                AdvanceProgress(Action.StopFullCalc);
            }
        }

        
        private string GetTileInfo(int flags, SQLiteConnection conn4)
        {
            using (SQLiteCommand cmd = new SQLiteCommand(
                "SELECT data FROM images WHERE flags=" + flags.ToString(), conn4))
            {
                using (SQLiteDataReader rdr = cmd.ExecuteReader())
                {
                    while (rdr.Read())
                    {
                        byte[] data = (byte[])rdr["data"];
                        int JpegQuality;
                        ImgFormat format = GetTileFormat(data, out JpegQuality);
                        if (format == ImgFormat.unifill)
                            continue;
                        string res = format.ToString();
                        if (format == ImgFormat.jpg || format == ImgFormat.cjpg)
                            res += ", quality: " + JpegQuality;
                        return res;
                    }
                }
                return Resource.empty;
            }

        }

        public ImgFormat GetTileFormat(byte[] img, out int JpegQuality)
        {
            JpegQuality = 0;
            if (img.Length == 3)
            {
                return ImgFormat.unifill;
            }
            else if (img.Length < 4)
                return ImgFormat.unknown;
            //Проверяем CJPG
            else if (img[0] == 67 && img[1] == 74 && img[2] == 80 && img[3] == 71
                /*Encoding.ASCII.GetString(img, 0, 4) == "CJPG"*/)
            {
                JpegQuality = img[9];
                return ImgFormat.cjpg;
            }
            else
            {
                Bitmap bmp = (Bitmap)Image.FromStream(new MemoryStream(img), false, false);
                if (bmp.RawFormat.Equals(ImageFormat.Png))
                    return ImgFormat.png;
                else if (!bmp.RawFormat.Equals(ImageFormat.Jpeg))
                    return ImgFormat.unknown;
                else
                {
                    ///Структура заголовка jpg файла следующая:
                    ///ff d8 ff код_блока ст_байт_длины_блока мл_байт_длины блока ....
                    ///.... ff da ст_байт_длины_блока мл_байт_длины блока ... данные изображения
                    int i, offset = 0;
                    int quality = -1;
                    for (i = 2; i < img.Length - 1; )
                    {
                        i += 2;
                        offset = img[i] * 0x100 + img[i + 1];
                        if (img[i - 1] == 0xda)
                            break;
                        else if (img[i - 1] == 0xdb && (img[i + 2] >> 4) == 0)
                        {
                            byte[] table = null;
                            if ((img[i + 2] & 0xf) == 0)
                                table = Form1.std_luminance_quant_tbl;
                            else
                                table = Form1.std_chrominance_quant_tbl;
                            double sf = 0;
                            bool allOnes = true;
                            int pos = i + 3;
                            for (int j = 0; j < 64; j++)
                            {
                                sf += 100.0 * (double)img[pos + j] / (double)table[j];
                                if (img[pos + j] != 1)
                                    allOnes = false;
                            }
                            sf /= 64;
                            if (allOnes)
                                quality = 100;
                            else if (sf < 100)
                                quality = (int)Math.Round(((200.0 - sf) / 2.0));
                            else
                                quality = (int)Math.Round(5000.0 / sf);
                            JpegQuality = quality;
                        }
                        i += offset;
                    }
                    return ImgFormat.jpg;
                }
            }
        }

        private void FileInfoDlg_Load(object sender, EventArgs e)
        {
/*            if (thread != null && thread.ThreadState == ThreadState.Running)
            {
                cancelThread = true;
                btnCalcStats.Enabled = false;
                return;
            }*/
            if (FileName == "")
            {
                MessageBox.Show(Resource.selectMap, Resource.selectMapCaption,
                    MessageBoxButtons.OK, MessageBoxIcon.Information);
                Close();
                return;
            }
            if (!File.Exists(FileName))
            {
                MessageBox.Show(Resource.fileNotExists, Resource.selectMapCaption,
                    MessageBoxButtons.OK, MessageBoxIcon.Information);
                Close();
                return;
            }
            progressBar2.Value = 0;
            progressBar2.Visible = true;
            cancelThread = false;
            thread = new Thread(CalcStats);
            thread.Start();

        }

        private void btnCalcStats_Click(object sender, EventArgs e)
        {
            cancelThread = true; 
            Close();
        }

        private void button1_Click(object sender, EventArgs e)
        {
            if (!File.Exists(FileName))
            {
                MessageBox.Show(Resource.fileNotExists, Resource.selectMapCaption,
                    MessageBoxButtons.OK, MessageBoxIcon.Information);
                Close();
                return;
            }
            progressBar2.Value = 0;
            progressBar2.Visible = true;
            cancelThread = false;
            thread = new Thread(CalcStatsFull);
            thread.Start();
        }


    }
}
