Proj4js.defs["EPSG:900913"] = "+title=GoogleMercator +proj=merc +a=6378137 +b=6378137 +lat_ts=0.0 +lon_0=0.0 +x_0=0.0 +y_0=0 +k=1.0 +units=m +nadgrids=@null +no_defs";
Proj4js.defs["EPSG:4326"] = "+proj=longlat +ellps=WGS84 +datum=WGS84 +no_defs";

Proj4js.defs["SR-ORG:6859"] = "+proj=merc +lon_0=0 +k=1 +x_0=0 +y_0=0 +ellps=intl +units=m +no_defs";
Proj4js.defs["EPSG:6859"] = "+proj=merc +lon_0=0 +k=1 +x_0=0 +y_0=0 +ellps=intl +units=m +no_defs";

if (OpenLayers.Renderer.SVG)
    OpenLayers.Renderer.SVG.prototype.inValidRange = function() {
        return true;
    }
NAVIONICS_PROJECTION = new OpenLayers.Projection("EPSG:6859");
DEG_PROJECTION = new OpenLayers.Projection("EPSG:4326");
GOOGLE_PROJECTION = new OpenLayers.Projection("EPSG:900913");

GOOGLE_BOUNDS = new OpenLayers.Bounds(-20037508.34, -20037508.34, 20037508.34, 20037508.34);
NAVIONICS_BOUNDS = new OpenLayers.Bounds(-20038300, -15433199, 20038300, 15433199);
NAVIONICS_RESTRICTED_BOUNDS = new OpenLayers.Bounds(-20038300, -9055453, 20038300, 12655453);

RESTRICTED_BOUNDS = NAVIONICS_RESTRICTED_BOUNDS;

NAVIONICS_RESOLUTIONS = [
	    // 156543.03390625,  // 19
	    // 78271.516953125,  // 18
	    // 39135.7584765625, // 17
	    19567.87923828125, // 16
	    9783.939619140625, // 15
	    4891.9698095703125, // 14
	    2445.9849047851562, // 13
	    1222.9924523925781, // 12
	
	    611.4962261962891, // 11
	    305.74811309814453, // 10
	    152.87405654907226, // 9
	    76.43702827453613, // 8
	    38.218514137268066, // 7
	    19.109257068634033, // 6
	    9.554628534317017, // 5
	    4.777314267158508, // 4
	    2.388657133579254, // 3
	
	    1.194328566789627 // 2
	    //0.5971642833948135 // 1

    ];
    
KM2MI = 0.621371192;
M2MI = 0.000621371192;

KMH2MS = 0.27;
KMH2FS = 0.9113;
KMH2MS = 0.27;

KM2NM = 0.539956803;
M2NM = 0.000539956803;

M2FT = 3.28084;
M2FA = 0.546806649;

OpenLayers.INCHES_PER_UNIT['NM'] = OpenLayers.INCHES_PER_UNIT['NautM']

NavionicsConstants = {
    a : 6378388,
    b : 6356911.946,
    f : 296 / 297
};

function toRad(value) {
    return value * Math.PI / 180;
};
function toDeg(value) {
    return value * 180 / Math.PI;
};

function toBrng(value) {
    return (toDeg(value) + 360) % 360;
};

function getTileIndexes(zoom, lonlat, projection) {

    if (zoom == 11)
        return getTileIndexes11(zoom, lonlat)

    if (projection == null)
        projection = NAVIONICS_PROJECTION;

    if (projection != DEG_PROJECTION)
        lonlat = lonlat.clone().transform(projection, DEG_PROJECTION);

    var TILE_ZOOMFACTOR = Math.pow(2, zoom)

    var latrad = lonlat.lat * Proj4js.common.D2R;

    var x = Math.floor((lonlat.lon + 180) * TILE_ZOOMFACTOR / 360);
    var y = Math.floor((1 - Math.log(Math.tan(latrad) + 1 / Math.cos(latrad)) / Math.PI) * TILE_ZOOMFACTOR / 2);
    return {
        'x' : x,
        'y' : y,
        'z' : zoom
    };
};

function getTileIndexes11(lonlat, projection) {
    // ZOOMFACTOR / 360.0 ;
    var TILE_ZOOMFACTOR_360 = 5.688888888888889;

    // 360 * 2;
    var TILE_ZOOMFACTOR_HALF = 1024;

    if (projection == null)
        projection = NAVIONICS_PROJECTION;

    if (projection != DEG_PROJECTION)
        lonlat = lonlat.clone().transform(projection, DEG_PROJECTION);

    // var zoom = 11;
    // var TILE_ZOOMFACTOR = 2048 // 2 ^ 11

    var latrad = lonlat.lat * Proj4js.common.D2R;

    var x = Math.floor((lonlat.lon + 180) * TILE_ZOOMFACTOR_360);
    var y = Math.floor((1 - Math.log(Math.tan(latrad) + 1 / Math.cos(latrad)) / Math.PI) * TILE_ZOOMFACTOR_HALF);
    return {
        'x' : x,
        'y' : y,
        'z' : 11
    };
};

function distNavionicsDeg(p1, p2) {
    var ct = NavionicsConstants;
    var a = ct.a, b = ct.b, f = ct.f;

    var L = OpenLayers.Util.rad(p2.lon - p1.lon);
    var U1 = Math.atan((1 - f) * Math.tan(OpenLayers.Util.rad(p1.lat)));
    var U2 = Math.atan((1 - f) * Math.tan(OpenLayers.Util.rad(p2.lat)));
    var sinU1 = Math.sin(U1), cosU1 = Math.cos(U1);
    var sinU2 = Math.sin(U2), cosU2 = Math.cos(U2);
    var lambda = L, lambdaP = 2 * Math.PI;
    var iterLimit = 20;
    while (Math.abs(lambda - lambdaP) > 1e-12 && --iterLimit > 0) {
        var sinLambda = Math.sin(lambda), cosLambda = Math.cos(lambda);
        var sinSigma = Math.sqrt((cosU2 * sinLambda) * (cosU2 * sinLambda) + (cosU1 * sinU2 - sinU1 * cosU2 * cosLambda) * (cosU1 * sinU2 - sinU1 * cosU2 * cosLambda));
        if (sinSigma == 0) {
            return 0;
            // co-incident points
        }
        var cosSigma = sinU1 * sinU2 + cosU1 * cosU2 * cosLambda;
        var sigma = Math.atan2(sinSigma, cosSigma);
        var alpha = Math.asin(cosU1 * cosU2 * sinLambda / sinSigma);
        var cosSqAlpha = Math.cos(alpha) * Math.cos(alpha);
        var cos2SigmaM = cosSigma - 2 * sinU1 * sinU2 / cosSqAlpha;
        var C = f / 16 * cosSqAlpha * (4 + f * (4 - 3 * cosSqAlpha));
        lambdaP = lambda;
        lambda = L + (1 - C) * f * Math.sin(alpha) * (sigma + C * sinSigma * (cos2SigmaM + C * cosSigma * (-1 + 2 * cos2SigmaM * cos2SigmaM)));
    }
    if (iterLimit == 0) {
        return NaN;
        // formula failed to converge
    }
    var uSq = cosSqAlpha * (a * a - b * b) / (b * b);
    var A = 1 + uSq / 16384 * (4096 + uSq * (-768 + uSq * (320 - 175 * uSq)));
    var B = uSq / 1024 * (256 + uSq * (-128 + uSq * (74 - 47 * uSq)));
    var deltaSigma = B * sinSigma * (cos2SigmaM + B / 4 * (cosSigma * (-1 + 2 * cos2SigmaM * cos2SigmaM) - B / 6 * cos2SigmaM * (-3 + 4 * sinSigma * sinSigma) * (-3 + 4 * cos2SigmaM * cos2SigmaM)));
    var s = b * A * (sigma - deltaSigma);
    var d = s.toFixed(3) / 1000;
    // round to 1mm precision
    return d;
};

function getDistanceNavionicsMercatorMeter(latitudeA, longitudeA, latitudeB, longitudeB) {
    var p1 = new OpenLayers.LonLat(longitudeA, latitudeA).transform(NAVIONICS_PROJECTION, DEG_PROJECTION)
    var p2 = new OpenLayers.LonLat(longitudeB, latitudeB).transform(NAVIONICS_PROJECTION, DEG_PROJECTION)
    return distNavionicsDeg(p1, p2)
}

function degreesToNm(latitude, longitude) {
    return new OpenLayers.LonLat(longitude, latitude).transform(DEG_PROJECTION, NAVIONICS_PROJECTION);
}

function nmToDegrees(latitude, longitude) {
    return new OpenLayers.LonLat(longitude, latitude).transform(NAVIONICS_PROJECTION, DEG_PROJECTION);
}

if (!Array.prototype.indexOf) {
    Array.prototype.indexOf = function(elt /*, from*/) {
        var len = this.length >>> 0;

        var from = Number(arguments[1]) || 0;
        from = (from < 0) ? Math.ceil(from) : Math.floor(from);
        if (from < 0)
            from += len;

        for (; from < len; from++) {
            if ( from in this && this[from] === elt)
                return from;
        }
        return -1;
    };
}

function getUnixTime(date) {
    if (date == null)
        date = new Date();

    return Math.round(date.getTime());
}

function fromUnixTime(utime) {
    return new Date(utime);
}

function randomUUID() {
    var s = [], itoh = '0123456789ABCDEF';

    // Make array of random hex digits. The UUID only has 32 digits in it, but we
    // allocate an extra items to make room for the '-'s we'll be inserting.
    for (var i = 0; i < 36; i++)
        s[i] = Math.floor(Math.random() * 0x10);

    // Conform to RFC-4122, section 4.4
    s[14] = 4;
    // Set 4 high bits of time_high field to version
    s[19] = (s[19] & 0x3) | 0x8;
    // Specify 2 high bits of clock sequence

    // Convert to hex chars
    for (var i = 0; i < 36; i++)
        s[i] = itoh[s[i]];

    // Insert '-'s
    s[8] = s[13] = s[18] = s[23] = '-';

    return s.join('');
}

function formatTime(hours) {
    var h = Math.floor(hours)
    var m = Math.floor((hours - h) * 60)
    if (m < 10)
        m = "0" + m;
    return h + "h " + m + "'"
}

function splitDegCoordinate(coordinate, axis) {
    coordinate = (coordinate + 540) % 360 - 180;
    // normalize for sphere being round

    var abscoordinate = Math.abs(coordinate);
    var coordinatedegrees = Math.floor(abscoordinate);

    var coordinateminutes = (abscoordinate - coordinatedegrees) / (1 / 60);
    var tempcoordinateminutes = coordinateminutes;
    coordinateminutes = Math.floor(coordinateminutes);
    var coordinateseconds = Math.round((tempcoordinateminutes - coordinateminutes) * 1000)

    if (coordinateseconds >= 1000) {
        coordinateseconds -= 1000;
        coordinateminutes += 1;
        if (coordinateminutes >= 60) {
            coordinateminutes -= 60;
            coordinatedegrees += 1;
        }
    }

    if (axis == "lon") {
        var coordinateaxis = coordinate < 0 ? "W" : "E";
    } else {
        var coordinateaxis = coordinate < 0 ? "S" : "N";
    }

    return {
        deg : coordinatedegrees,
        minutes : coordinateminutes,
        seconds : coordinateseconds,
        axis : coordinateaxis
    }

};

function distNavionics(p1, p2) {
    var ct = NavionicsConstants;
    var a = ct.a, b = ct.b, f = ct.f;

    var L = OpenLayers.Util.rad(p2.lon - p1.lon);
    var U1 = Math.atan((1 - f) * Math.tan(OpenLayers.Util.rad(p1.lat)));
    var U2 = Math.atan((1 - f) * Math.tan(OpenLayers.Util.rad(p2.lat)));
    var sinU1 = Math.sin(U1), cosU1 = Math.cos(U1);
    var sinU2 = Math.sin(U2), cosU2 = Math.cos(U2);
    var lambda = L, lambdaP = 2 * Math.PI;
    var iterLimit = 20;
    while (Math.abs(lambda - lambdaP) > 1e-12 && --iterLimit > 0) {
        var sinLambda = Math.sin(lambda), cosLambda = Math.cos(lambda);
        var sinSigma = Math.sqrt((cosU2 * sinLambda) * (cosU2 * sinLambda) + (cosU1 * sinU2 - sinU1 * cosU2 * cosLambda) * (cosU1 * sinU2 - sinU1 * cosU2 * cosLambda));
        if (sinSigma == 0) {
            return 0;
            // co-incident points
        }
        var cosSigma = sinU1 * sinU2 + cosU1 * cosU2 * cosLambda;
        var sigma = Math.atan2(sinSigma, cosSigma);
        var alpha = Math.asin(cosU1 * cosU2 * sinLambda / sinSigma);
        var cosSqAlpha = Math.cos(alpha) * Math.cos(alpha);
        var cos2SigmaM = cosSigma - 2 * sinU1 * sinU2 / cosSqAlpha;
        var C = f / 16 * cosSqAlpha * (4 + f * (4 - 3 * cosSqAlpha));
        lambdaP = lambda;
        lambda = L + (1 - C) * f * Math.sin(alpha) * (sigma + C * sinSigma * (cos2SigmaM + C * cosSigma * (-1 + 2 * cos2SigmaM * cos2SigmaM)));
    }
    if (iterLimit == 0) {
        return NaN;
        // formula failed to converge
    }
    var uSq = cosSqAlpha * (a * a - b * b) / (b * b);
    var A = 1 + uSq / 16384 * (4096 + uSq * (-768 + uSq * (320 - 175 * uSq)));
    var B = uSq / 1024 * (256 + uSq * (-128 + uSq * (74 - 47 * uSq)));
    var deltaSigma = B * sinSigma * (cos2SigmaM + B / 4 * (cosSigma * (-1 + 2 * cos2SigmaM * cos2SigmaM) - B / 6 * cos2SigmaM * (-3 + 4 * sinSigma * sinSigma) * (-3 + 4 * cos2SigmaM * cos2SigmaM)));
    var s = b * A * (sigma - deltaSigma);
    var d = s.toFixed(3) / 1000;
    // round to 1mm precision
    return d;
};

function getFormattedLonLatMillis(coordinate, axis) {
    var r = splitDegCoordinate(coordinate, axis)

    if (r < 10) {
        r['deg'] = "0" + r['deg'];
    }
    var str = r['deg'] + "\u00B0";

    if (r['minutes'] < 10) {
        r['minutes'] = "0" + r['minutes'];
    }
    str += r['minutes'] + ".";

    if (r['seconds'] < 10) {
        str += "0";
    }

    if (r['seconds'] < 100) {
        str += "0";
    }

    str += r['seconds'];

    str += r['axis']
    return str;
};

function toRad(value) {
    return value * Math.PI / 180;
};
function toDeg(value) {
    return value * 180 / Math.PI;
};

function toBrng(value) {
    return (toDeg(value) + 360) % 360;
};

function bearingNavionicsMercator(p1, p2) {
    var lon1 = p1.lon;
    var lon2 = p2.lon;
    var lat1 = p1.lat;
    var lat2 = p2.lat;

    var dLon = lon2 - lon1;
    var dLat = lat2 - lat1;

    return toBrng(Math.atan2(dLon, dLat));
};

function getBearingNavionicsMercator(latitudeA, longitudeA, latitudeB, longitudeB) {
    var p1 = new OpenLayers.LonLat(longitudeA, latitudeA)
    var p2 = new OpenLayers.LonLat(longitudeB, latitudeB)
    return bearingNavionicsMercator(p1, p2)
}

NavionicsMaps = {
    getMapRaster : function(
        left,
        bottom,
        right,
        top,
        key,
        options
    ) {
        /* 
        options: {
            base,   // optional, default "http://webviewer-api.navionics.com/getmap"
            transparence, // optional, default false
            depth_level, // optional 0-4 , default 0
            depth_unit  // optional // "fa","ft","mt"
            ugd // optional, default 0 
        }        
        */
        
        if (!options) 
            options = {}
        var base = options.base || "http://webviewer-api.navionics.com/getmap";
        var transparence = options.transparence != undefined? options.transparence : false;
        var ugd = options.ugd != undefined? options.ugd : false;
        var depth_level = options.depth_level != undefined? options.depth_level : 0;
        
        switch(options.depth_unit) {
                case "fa":
                    var depth_unit = 3
                    break;

                case "ft":
                    var depth_unit = 2
                    break;

                default:
                    var depth_unit = 1
                    break;
            }
        
        var layer_string = 'config_' + depth_unit + "_" + depth_level + "_" + ugd ? 1 : 0;
        var allParams = {
            LAYERS : layer_string,
            TRANSPARENT : transparence ? "TRUE" : "FALSE",
            SERVICE : "WMS",
            VERSION : "1.1.1",
            REQUEST : "GetMap",
            STYLES : null,
            FORMAT : "image/png",
            SRS : "EPSG:6859",
            BBOX : [left, bottom, right, top].join(","),
            WIDTH : 256,
            HEIGHT : 256        
        }
        
        var paramsString = OpenLayers.Util.getParameterString(allParams);
        var encoded = base + "?PARAMS=";
        var encParams =""
        
        for (var i = 0; i < paramsString.length; i++) {
            encParams += String.fromCharCode(paramsString.charCodeAt(i) ^ 42);
        }

        return encoded + Base64.encode(encParams).replace(/\+/g, "%2b") + "&NAVKEY=" + key;
    }
}
var Base64 = {

    // private property
    _keyStr : "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/=",

    // public method for encoding
    encode : function(input) {
        var output = "";
        var chr1, chr2, chr3, enc1, enc2, enc3, enc4;
        var i = 0;

        input = Base64._utf8_encode(input);

        while (i < input.length) {

            chr1 = input.charCodeAt(i++);
            chr2 = input.charCodeAt(i++);
            chr3 = input.charCodeAt(i++);

            enc1 = chr1 >> 2;
            enc2 = ((chr1 & 3) << 4) | (chr2 >> 4);
            enc3 = ((chr2 & 15) << 2) | (chr3 >> 6);
            enc4 = chr3 & 63;

            if (isNaN(chr2)) {
                enc3 = enc4 = 64;
            } else if (isNaN(chr3)) {
                enc4 = 64;
            }

            output = output + this._keyStr.charAt(enc1) + this._keyStr.charAt(enc2) + this._keyStr.charAt(enc3) + this._keyStr.charAt(enc4);
        }

        return output;
    },

    // public method for decoding
    decode : function(input) {
        var output = "";
        var chr1, chr2, chr3;
        var enc1, enc2, enc3, enc4;
        var i = 0;

        input = input.replace(/[^A-Za-z0-9\+\/\=]/g, "");

        while (i < input.length) {

            enc1 = this._keyStr.indexOf(input.charAt(i++));
            enc2 = this._keyStr.indexOf(input.charAt(i++));
            enc3 = this._keyStr.indexOf(input.charAt(i++));
            enc4 = this._keyStr.indexOf(input.charAt(i++));

            chr1 = (enc1 << 2) | (enc2 >> 4);
            chr2 = ((enc2 & 15) << 4) | (enc3 >> 2);
            chr3 = ((enc3 & 3) << 6) | enc4;

            output = output + String.fromCharCode(chr1);

            if (enc3 != 64) {
                output = output + String.fromCharCode(chr2);
            }
            if (enc4 != 64) {
                output = output + String.fromCharCode(chr3);
            }

        }

        output = Base64._utf8_decode(output);

        return output;

    },

    // private method for UTF-8 encoding
    _utf8_encode : function(string) {
        string = string.replace(/\r\n/g, "\n");
        var utftext = "";

        for (var n = 0; n < string.length; n++) {

            var c = string.charCodeAt(n);

            if (c < 128) {
                utftext += String.fromCharCode(c);
            } else if ((c > 127) && (c < 2048)) {
                utftext += String.fromCharCode((c >> 6) | 192);
                utftext += String.fromCharCode((c & 63) | 128);
            } else {
                utftext += String.fromCharCode((c >> 12) | 224);
                utftext += String.fromCharCode(((c >> 6) & 63) | 128);
                utftext += String.fromCharCode((c & 63) | 128);
            }

        }

        return utftext;
    },

    // private method for UTF-8 decoding
    _utf8_decode : function(utftext) {
        var string = "";
        var i = 0;
        var c = c1 = c2 = 0;

        while (i < utftext.length) {

            c = utftext.charCodeAt(i);

            if (c < 128) {
                string += String.fromCharCode(c);
                i++;
            } else if ((c > 191) && (c < 224)) {
                c2 = utftext.charCodeAt(i + 1);
                string += String.fromCharCode(((c & 31) << 6) | (c2 & 63));
                i += 2;
            } else {
                c2 = utftext.charCodeAt(i + 1);
                c3 = utftext.charCodeAt(i + 2);
                string += String.fromCharCode(((c & 15) << 12) | ((c2 & 63) << 6) | (c3 & 63));
                i += 3;
            }

        }

        return string;
    }
}

if (!('forEach' in Array.prototype)) {
    Array.prototype.forEach = function(action, that /*opt*/) {
        for (var i = 0, n = this.length; i < n; i++)
            if ( i in this)
                action.call(that, this[i], i, this);
    };
}

