program ReadPNG;

{$IFDEF FPC}
  {$MODE Delphi}

  {$IFDEF CPUI386}
    {$DEFINE CPU386}
    {$ASMMODE INTEL}
  {$ENDIF}

  {$IFNDEF WIN32}
    {$LINKLIB c}
  {$ENDIF}
{$ELSE}
  {$APPTYPE CONSOLE}
{$ENDIF}


uses
  Classes,
  SysUtils,
  libPNG in '..\libPNG.pas';


var
  signature: array [0..7] of byte;
  stream: TFileStream;
  png: png_structp;
  png_info: png_infop;
  png_rows: array of Pointer;
  Row: Integer;



procedure read_from_stream(png: png_structp; buffer: png_bytep; size: cardinal); cdecl;
var
  FS: TStream;
begin
  FS := TStream(png_get_io_ptr(png));

  FS.Read(buffer^, size);
end;


begin
  // *** help ***
  if ParamCount = 0 then begin
    writeln('Reads an PNG file');
    writeln('');
    writeln('usage:');
    writeln('  ReadPNG.exe PNGImage');
    halt;
  end;

  // *** initialization ***
  if not init_libPNG then begin
    writeln('ERROR: Couldn''t initialize libPNG.');
    halt;
  end;

  // *** version ***
  writeln('ReadPNG using libPNG (', png_get_libpng_ver(nil), ')');
  writeln('');

  // *** reading file ***
  writeln(ParamStr(1));
  stream := TFileStream.Create(ParamStr(1), fmOpenRead);

  // checking signature
  stream.Read(signature, 8);

  if png_check_sig(@signature, 8) = 0 then begin
    writeln('ERROR: the given file isn''t an png.');
    halt;
  end;

  // creating png struct
  png := png_create_read_struct(PNG_LIBPNG_VER_STRING, nil, nil, nil);
  if png = nil then begin
    writeln('ERROR: error creating png struct.');
    halt;
  end;

  // creating info struct
  png_info := png_create_info_struct(png);
  if png_info = nil then begin
    png_destroy_read_struct(@png, nil, nil);

    writeln('ERROR: error creating info struct');
    halt;
  end;

  // set read callback
  png_set_read_fn(png, stream, read_from_stream);

  // we have read the signature so skip the first 8 bytes
  png_set_sig_bytes(png, 8);

  // read informations
  png_read_info(png, png_info);

  // allocating mem for scanlines
  SetLength(png_rows, png_get_image_height(png, png_info));

  for Row := Low(png_rows) to High(png_rows) do
    GetMem(png_rows[Row], png_get_rowbytes(png, png_info));

  // read complete image into scanlines
  png_read_image(png, @png_rows[0]);

  // read end
  png_read_end(png, png_info);


  // do anything with the data
  writeln('loading successful');


  // *** finalization input ***
  stream.Free;

  png_destroy_read_struct(@png, @png_info, nil);

  for Row := Low(png_rows) to High(png_rows) do
    FreeMem(png_rows[Row]);

  SetLength(png_rows, 0);

  // not really necessary in this case
  quit_libPNG;
end.
 