program JpegTest;

{$APPTYPE CONSOLE}

uses
  Windows,
  SysUtils,
  Classes,
  LibJpeg8 in 'LibJpeg\LibJpeg8.pas',
  LibJpeg62 in 'LibJpeg\LibJpeg62.pas',
  LibJpegTran in 'LibJpeg\LibJpegTran.pas',
  LibJpegInOutDataManager in 'LibJpeg\LibJpegInOutDataManager.pas',
  LibJpegErrorHandler in 'LibJpeg\LibJpegErrorHandler.pas',
  LibJpegRead in 'LibJpeg\LibJpegRead.pas',
  LibJpegWrite in 'LibJpeg\LibJpegWrite.pas',
  LibJpegLosslless in 'LibJpeg\LibJpegLosslless.pas';

const
  //CUseJpeg8 = False;
  CUseJpeg8 = True;
(*
procedure ReaderTest;
var
  VStream: TFileStream;
  VMem: TMemoryStream;
  VJpegReader: TJpegReader;
  VMarkers: TJpegMarkersList;
begin
  VStream := TFileStream.Create('GoodImg.jpg'{'P1030570.jpg'}, fmOpenRead);
  //VStream := TFileStream.Create('BadImg.jpg', fmOpenRead);
  try
    VJpegReader := TJpegReader.Create(VStream, CUseJpeg8);
    try

      VJpegReader.SaveMarkers := True;
      if VJpegReader.ReadHeader then begin
        VMarkers := VJpegReader.MarkersList;
      end;

      VMem := TMemoryStream.Create;
      try
        if VJpegReader.Decompress(VMem) then begin
          VMem.SaveToFile('GoodImg.raw');
          //VMem.SaveToFile('BadImg.raw');
        end;
      finally
        VMem.Free;
      end;
    finally
      VJpegReader.Free;
    end;
  finally
    VStream.Free;
  end;
end;

procedure WriterTest;
var
  VInPut: TFileStream;
  VOutPut: TMemoryStream;
  VJpegWriter: TJpegWriter;
begin
  VOutPut := TMemoryStream.Create;
  try
    VJpegWriter := TJpegWriter.Create(VOutPut, CUseJpeg8);
    try
      VInPut := TFileStream.Create('GoodImg.raw', fmOpenRead);
      //VInPut := TFileStream.Create('BadImg.jpg', fmOpenRead);
      try
        VJpegWriter.Width := 256;
        VJpegWriter.Height := 256;
        VInPut.Position := 0;
        VJpegWriter.AddCommentMarker('Test marker comment');
        if VJpegWriter.Compress(VInPut) then begin
          VOutPut.SaveToFile('GoodImgNew.jpg');
          //VOutPut.SaveToFile('BadImgNew.jpg');
        end;
      finally
        VInPut.Free;
      end;
    finally
      VJpegWriter.Free;
    end;
  finally
    VOutPut.Free;
  end;
end;
*)
procedure CropTest(W,H: Integer);
var
  VInPut: TFileStream;
  VOutPut: TFileStream;
begin
  VOutPut := TFileStream.Create('joutput.jpg', fmCreate);
  try
    VInPut := TFileStream.Create('jtile.jpg', fmOpenRead);
    try
      crop(VInPut, VOutPut, 0, 0, H, W);
    finally
      VInPut.Free;
    end;
  finally
    VOutPut.Free;
  end;
end;

procedure DropTest(W, H: Integer);
var
  VInPut: TFileStream;
  VOutPut: TFileStream;
  VTile: TFileStream;
  i,j,k: Integer;
  VTick: Cardinal;
  VStart, VFinish: TDateTime;
begin
  VOutPut := TFileStream.Create('joutput.jpg', fmOpenReadWrite or fmShareDenyWrite);
  try
    VTile := TFileStream.Create('jtile.jpg', fmOpenRead);
    try
      VInPut := TFileStream.Create('joutput.jpg', fmOpenRead or fmShareDenyNone);
      try
        Writeln('Drop test start!');
        VStart := Now;
        VTick := GetTickCount;
        k := 0;
        for I := 0 to (W div 256) - 1 do begin
          for J := 0 to (H div 256) - 1 do begin
            VOutPut.Position := 0;
            VInPut.Position := 0;
            VTile.Position := 0;
            drop(VInPut, VOutPut, VTile, j*256, i*256);
            Inc(k);
            Writeln(
              FloatToStrF((GetTickCount - VTick)/1000, ffNumber, 4, 3) +
              ' Dropped tile: ' + IntToStr(k) + ' of ' +
              IntToStr((H div 256) * (W div 256))
            );
            VTick := GetTickCount;
          end;
        end;
        VFinish := Now;
        Writeln('Drop test is finished!');
        Writeln('Start  : ' + DateTimeToStr(VStart));
        Writeln('Finish : ' + DateTimeToStr(VFinish));
      finally
        VInPut.Free;
      end;
    finally
      VTile.Free;
    end;
  finally
    VOutPut.Free;
  end;
end;

var
  w,h: Integer;
begin
  try
    //ReaderTest;
    //WriterTest;
    if ParamCount < 2 then begin
      Writeln('Usage: JpegTest.exe <width> <height>');
    end else begin
      w := StrToInt(ParamStr(1));
      h := StrToInt(ParamStr(2));
      CropTest(w, h);
      DropTest(w, h);
    end;
    Readln;
  except
    on E:Exception do
      Writeln(E.Classname, ': ', E.Message);
  end;
end.
