program sml_load;

{$APPTYPE CONSOLE}

uses
  Classes,
  SysUtils,
  MidasSpeedFix,
  MidasLib,
  AlcinoeParserTest in 'AlcinoeParserTest.pas',
  DataSetParserTest in 'DataSetParserTest.pas',
  i_Timer in 'Timer\i_Timer.pas',
  u_TimerByGetTickCount64 in 'Timer\u_TimerByGetTickCount64.pas',
  u_TimerByGetTickCount in 'Timer\u_TimerByGetTickCount.pas',
  u_TimerByNtQueryPerformanceCounter in 'Timer\u_TimerByNtQueryPerformanceCounter.pas',
  u_TimerByQueryPerformanceCounter in 'Timer\u_TimerByQueryPerformanceCounter.pas',
  OXmlParserTest in 'OXmlParserTest.pas',
  OBufferedStreams in 'OXml\units\OBufferedStreams.pas',
  ODictionary in 'OXml\units\ODictionary.pas',
  OEncoding in 'OXml\units\OEncoding.pas',
  OHashedStrings in 'OXml\units\OHashedStrings.pas',
  OTextReadWrite in 'OXml\units\OTextReadWrite.pas',
  OWideSupp in 'OXml\units\OWideSupp.pas',
  OXmlCDOM in 'OXml\units\OXmlCDOM.pas',
  OXmlDOMVendor in 'OXml\units\OXmlDOMVendor.pas',
  OXmlLng in 'OXml\units\OXmlLng.pas',
  OXmlPDOM in 'OXml\units\OXmlPDOM.pas',
  OXmlReadWrite in 'OXml\units\OXmlReadWrite.pas',
  OXmlSAX in 'OXml\units\OXmlSAX.pas',
  OXmlSeq in 'OXml\units\OXmlSeq.pas',
  OXmlUtils in 'OXml\units\OXmlUtils.pas',
  OXmlXPath in 'OXml\units\OXmlXPath.pas',
  MarksSmlToDataSet in 'MarksSmlToDataSet.pas';

function GetTimer: ITimer;
begin
  Result := MakeTimerByQueryPerformanceCounter;
  if not Assigned(Result) then begin
    Writeln('QueryPerformanceCounter does not work');
    Result := MakeTimerByNtQueryPerformanceCounter;
  end;
  if not Assigned(Result) then begin
    Writeln('NtQueryPerformanceCounter does not work');
    Result := MakeTimerByGetTickCount;
  end;
end;

procedure ProcessTests(const AStream: TStream; const ATimer: ITimer);
var
  VAlcinoeTester: TAlcinoeXMLTester;
  VOXmlTester: TOXmlTester;
begin
  VAlcinoeTester := TAlcinoeXMLTester.Create;
  try
    VAlcinoeTester.TestIt(AStream, ATimer);
  finally
    VAlcinoeTester.Free;
  end;

  Writeln;

  VOXmlTester := TOXmlTester.Create;
  try
    VOXmlTester.TestIt(AStream, ATimer);
  finally
    VOXmlTester.Free;
  end;

  Writeln;

  TestDataSetParser(AStream, ATimer);

  Writeln;
end;

procedure XmlToDataSet(const AStream: TStream; const ATimer: ITimer);
var
  VAlImporter: TAlcinoeXmlToDataSet;
begin
  VAlImporter := TAlcinoeXmlToDataSet.Create;
  try
    VAlImporter.Process(AStream, ATimer);
  finally
    VAlImporter.Free;
  end;
end;

var
  VTimer: ITimer;
  VTimeStart, VTimeFinish: Int64;
  VFileName: string;
  VStream: TMemoryStream;
begin
  try
    VFileName := 'marks.sml';

    VStream := TMemoryStream.Create;
    try
      VTimer := GetTimer;

      VTimeStart := VTimer.CurrentTime;
      VStream.LoadFromFile(VFileName);
      VTimeFinish := VTimer.CurrentTime;

      Writeln(Format('File "%s" loaded to memory at %.8f sec.', [VFileName, (VTimeFinish - VTimeStart)/VTimer.Freq]));
      Writeln;

      ProcessTests(VStream, VTimer);
      XmlToDataSet(VStream, VTimer);
    finally
      VStream.Free; 
    end;

    Writeln('Finished. Press ENTER to exit...');
    Readln;
  except
    on E:Exception do begin
      Writeln(E.Classname, ': ', E.Message);
      Readln;
    end;
  end;
end.
