unit DataSetParserTest;

interface

uses
  Windows,
  Classes,
  SysUtils,
  DBClient,
  i_Timer;

procedure TestDataSetParser(const AStream: TStream; const ATimer: ITimer);

implementation

procedure TestDataSetParser(const AStream: TStream; const ATimer: ITimer);
var
  XML: AnsiString;
  VDir: string;
  VDataSet: TClientDataSet;
  VStartTime, VFinishTime: Int64;
  VTime1, VTime2: Double;
begin
  VDataSet := TClientDataSet.Create(nil);
  try
    VDataSet.Name := 'Test';
    VDataSet.DisableControls;

    AStream.Position := 0;

    VStartTime := ATimer.CurrentTime;

    SetLength(XML, AStream.Size);
    AStream.ReadBuffer(XML[1], Length(XML));

    VFinishTime := ATimer.CurrentTime;

    VTime1 := (VFinishTime - VStartTime)/ATimer.Freq;

    VStartTime := ATimer.CurrentTime;
    VDataSet.XMLData := string(XML);
    VFinishTime := ATimer.CurrentTime;

    VTime2 := (VFinishTime - VStartTime)/ATimer.Freq;

    Writeln(Format('DataSet SetXML: %.8f sec. (%.8f + %.8f)', [(VTime1+VTime2), VTime1, VTime2]));

    XML := '';
    VDataSet.XMLData := '';
    AStream.Position := 0;

    VStartTime := ATimer.CurrentTime;
    VDataSet.LoadFromStream(AStream);
    VFinishTime := ATimer.CurrentTime;

    Writeln(Format('DataSet LoadFromStream: %.8f sec.', [(VFinishTime - VStartTime)/ATimer.Freq]));

    Writeln;

    VDir := '.\tmp\';
    ForceDirectories(VDir);

    VStartTime := ATimer.CurrentTime;
    VDataSet.SaveToFile(VDir + 'tmp.cds', dfBinary);
    VFinishTime := ATimer.CurrentTime;

    Writeln(Format('DataSet SaveToFile %stmp.cds: %.8f sec.', [VDir, (VFinishTime - VStartTime)/ATimer.Freq]));

    VStartTime := ATimer.CurrentTime;
    VDataSet.SaveToFile(VDir + 'tmp.sml', dfXML);
    VFinishTime := ATimer.CurrentTime;

    Writeln(Format('DataSet SaveToFile %stmp.sml: %.8f sec.', [VDir, (VFinishTime - VStartTime)/ATimer.Freq]));

    VStartTime := ATimer.CurrentTime;
    VDataSet.SaveToFile(VDir + 'tmp.utf8.sml', dfXMLUTF8);
    VFinishTime := ATimer.CurrentTime;

    Writeln(Format('DataSet SaveToFile %stmp.utf8.sml: %.8f sec.', [VDir, (VFinishTime - VStartTime)/ATimer.Freq]));

    Writeln;

    VDataSet.XMLData := '';
    VStartTime := ATimer.CurrentTime;
    VDataSet.LoadFromFile(VDir + 'tmp.cds');
    VFinishTime := ATimer.CurrentTime;

    Writeln(Format('DataSet LoadFromFile %stmp.cds: %.8f sec.', [VDir, (VFinishTime - VStartTime)/ATimer.Freq]));
  finally
    VDataSet.Free;
  end;
end;

end.
