unit uPlaces;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ComCtrls, StdCtrls, Grids, ExtCtrls, ToolWin, ImgList, Buttons, ActnList;

type
  TfmPlaces = class(TForm)
    PageControl1: TPageControl;
    tsPlaces: TTabSheet;
    Button2: TButton;
    Button1: TButton;
    tsClasses: TTabSheet;
    sgPlaces: TStringGrid;
    sgClasses: TStringGrid;
    Panel1: TPanel;
    edPlaceName: TEdit;
    edPlaceLon: TEdit;
    cbPlaceClass: TComboBox;
    Label1: TLabel;
    Label3: TLabel;
    Label4: TLabel;
    ilButtons: TImageList;
    Panel2: TPanel;
    actnlst: TActionList;
    PlaceSave: TAction;
    PlaceAdd: TAction;
    PlaceDel: TAction;
    SpeedButton1: TSpeedButton;
    SpeedButton2: TSpeedButton;
    SpeedButton3: TSpeedButton;
    Panel3: TPanel;
    SpeedButton4: TSpeedButton;
    SpeedButton5: TSpeedButton;
    SpeedButton6: TSpeedButton;
    Panel4: TPanel;
    Label6: TLabel;
    Label7: TLabel;
    Label8: TLabel;
    edClassID: TEdit;
    edClassName: TEdit;
    ClassSave: TAction;
    ClassAdd: TAction;
    ClassDel: TAction;
    ofClassColor: TPanel;
    cbClassVisible: TCheckBox;
    Label5: TLabel;
    ColorDialog: TColorDialog;
    Label2: TLabel;
    edPlaceLat: TEdit;
    procedure FormCreate(Sender: TObject);
    procedure sgPlacesClick(Sender: TObject);
    procedure PlaceSaveExecute(Sender: TObject);
    procedure PlaceAddExecute(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure PlaceDelExecute(Sender: TObject);
    procedure ClassSaveExecute(Sender: TObject);
    procedure ClassAddExecute(Sender: TObject);
    procedure ClassDelExecute(Sender: TObject);
    procedure sgClassesClick(Sender: TObject);
    procedure ofClassColorDblClick(Sender: TObject);
  private
    { Private-Deklarationen }
    procedure UpdClassList;
    procedure DeleteRow(Grid: TStringGrid; RowNumber: Integer);
    procedure SetupGrid(Grid: TStringGrid; const Captions: array of string;
      const Widths: array of Integer);
  public
    { Public-Deklarationen }
    function GridRowEmpty(Grid: TStringGrid; ARow: integer): boolean;
    function GetString(Grid: TStringGrid; Col: integer): String;
    procedure PutRow(Grid:TStringGrid; ARow:integer; const Values:array of string);
    procedure AddRow(Grid:TStringGrid; const Values:array of string);
  end;

var
  fmPlaces: TfmPlaces;

implementation

{$R *.DFM}

procedure TfmPlaces.SetupGrid(Grid:TStringGrid; const Captions:array of string;
                    const Widths:array of Integer);
var i:integer;
begin
  with Grid do begin
    RowCount:= 2;
    Rows[0].Clear;
    Rows[1].Clear;
    ColCount:= length(Captions);
    DefaultRowHeight:= -Grid.Font.Height+5;
    Options:= Options+[goRowSelect,goThumbTracking]-[goRangeSelect];
    for i:= 0 to ColCount-1 do begin
      Cells[i,0]:= Captions[i];
      ColWidths[i]:= Widths[i];
    end;
  end;
end;
           
function TfmPlaces.GridRowEmpty(Grid:TStringGrid;ARow:integer):boolean;
var i:integer;
begin
  Result:= true;
  with Grid do begin
    for i:= 0 to ColCount-1 do
      Result:= (Cells[i,ARow]='') and Result;
  end;
end;

function TfmPlaces.GetString(Grid:TStringGrid; Col:integer):String;
begin
  Result:= Grid.Cells[Col,Grid.Row];
end;

procedure TfmPlaces.DeleteRow(Grid : TStringGrid; RowNumber : Integer);
Var 
  i : Integer; 
Begin
  Grid.Row := RowNumber;
  If (Grid.Row = Grid.RowCount -1) Then 
  Begin 
    {On the last row} 
    if (not GridRowEmpty(grid,RowNumber)) and
       (Grid.FixedRows+1>RowNumber)

    then
      Grid.RowCount := Grid.RowCount - 1;
  End
  Else 
  Begin
    {Not the last row} 
    For i := RowNumber To Grid.RowCount - 1 Do 
    Begin 
      Grid.Rows[i] := Grid.Rows[i+ 1]; 
    End; 
    Grid.RowCount := Grid.RowCount - 1; 
  End; 
End;

procedure TfmPlaces.PutRow(Grid: TStringGrid; ARow: integer;
  const Values: array of string);
var i:integer;
begin
  with Grid do begin
    for i:= 0 to Length(Values)-1 do
      Cells[i,ARow]:= Values[i];
  end;
end;

procedure TfmPlaces.AddRow(Grid: TStringGrid;
  const Values: array of string);

begin
  PutRow(Grid,Grid.RowCount-1,Values);
  grid.Row:= Grid.RowCount-1;
  Grid.RowCount:= Grid.RowCount+1;
end;

procedure TfmPlaces.sgPlacesClick(Sender: TObject);
begin
  if not GridRowEmpty(sgPlaces,sgPlaces.Row) then begin
    edPlaceName.Text:= GetString(sgPlaces,0);
    edPlaceLon.Text:= GetString(sgPlaces,1);
    edPlaceLat.Text:= GetString(sgPlaces,2);
    UpdClassList;
    cbPlaceClass.ItemIndex:= cbPlaceClass.Items.IndexOfName(GetString(sgPlaces,3));
  end else begin
    edPlaceName.Text:= '';
    edPlaceLon.Text:= '';
    edPlaceLat.Text:= '';
    UpdClassList;
    cbPlaceClass.ItemIndex:= -1;
  end;
end;

procedure TfmPlaces.sgClassesClick(Sender: TObject);
begin
  if not GridRowEmpty(sgClasses,sgClasses.Row) then begin
    edClassID.Text:= GetString(sgClasses,1);
    edClassName.Text:= GetString(sgClasses,2);
    cbClassVisible.Checked:= strtoint(GetString(sgClasses,0))=1;
    ofClassColor.Color:= strtoint(GetString(sgClasses,3));
  end else begin
    edClassID.Text:= '';
    edClassName.Text:= '';
    cbClassVisible.Checked:= true;
    ofClassColor.Color:= clRed;
  end;
end;

procedure TfmPlaces.UpdClassList;
var i:integer;
begin
  cbPlaceClass.Clear;
  with sgClasses do begin
    for i:= 1 to RowCount-2 do begin
      cbPlaceClass.Items.Add(Cells[1,i]+'='+Cells[2,i]);
    end;
  end;
end;

procedure TfmPlaces.FormCreate(Sender: TObject);
begin
  SetupGrid(sgPlaces,['Name','Longitude','Latitude','Class'],[200,60,60,60]);
  SetupGrid(sgClasses,['Visible','ID','Name','Color'],[50,25,200,80]);
  PageControl1.ActivePage:= tsClasses;
end;

procedure TfmPlaces.FormShow(Sender: TObject);
begin
  sgPlacesClick(self);
  sgClassesClick(self);
end;

procedure TfmPlaces.PlaceSaveExecute(Sender: TObject);
begin
  if not GridRowEmpty(sgPlaces,sgPlaces.Row) then
    PutRow(sgPlaces,sgPlaces.Row,
           [edPlaceName.Text,edPlaceLat.Text,edPlaceLon.Text,cbPlaceClass.Items.Names[cbPlaceClass.itemIndex]])
  else
    PlaceAdd.Execute;
end;

procedure TfmPlaces.PlaceAddExecute(Sender: TObject);
begin
  AddRow(sgPlaces,
         [edPlaceName.Text,edPlaceLat.Text,edPlaceLon.Text,cbPlaceClass.Items.Names[cbPlaceClass.itemIndex]]);
end;

procedure TfmPlaces.PlaceDelExecute(Sender: TObject);
begin
  DeleteRow(sgPlaces,sgPlaces.Row);
end;

procedure TfmPlaces.ClassSaveExecute(Sender: TObject);
begin
  if not GridRowEmpty(sgPlaces,sgPlaces.Row) then
    PutRow(sgClasses,sgClasses.Row,
           [IntToStr(ord(cbClassVisible.Checked)),edClassID.Text,edClassName.Text,'$'+IntToHex(ofClassColor.Color,8)])
  else
    ClassAdd.Execute;
end;

procedure TfmPlaces.ClassAddExecute(Sender: TObject);
begin
  AddRow(sgClasses,
         [IntToStr(ord(cbClassVisible.Checked)),edClassID.Text,edClassName.Text,'$'+IntToHex(ofClassColor.Color,8)]);
end;

procedure TfmPlaces.ClassDelExecute(Sender: TObject);
begin
  DeleteRow(sgClasses,sgClasses.Row);
end;

procedure TfmPlaces.ofClassColorDblClick(Sender: TObject);
begin
  ColorDialog.Color:= ofClassColor.Color;
  if ColorDialog.Execute then ofClassColor.Color:= ColorDialog.Color;
end;

end.
