unit uBrowser;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ExtCtrls, StdCtrls, uSrtm, Grids, uUtils;

type
  TfmBrowser = class(TForm)
    btnReload: TButton;
    lbName: TLabel;
    btnPreview: TButton;
    Image1: TImage;
    btnOpen: TButton;
    imWorld: TImage;
    imPart: TImage;
    lbCurr: TLabel;
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure btnReloadClick(Sender: TObject);
    procedure btnOpenClick(Sender: TObject);
    procedure FormActivate(Sender: TObject);
    procedure imPartMouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure imWorldMouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure imPartMouseMove(Sender: TObject; Shift: TShiftState; X,
      Y: Integer);
    procedure btnPreviewClick(Sender: TObject);
  private
    { Private-Deklarationen }
    World:TMetafile;
    IntWrl,IntPar:TBitmap;
    MTop,MLeft:integer;
    curr:TCoordinates;
    Res:integer;

    Avail: array[-180..180,-90..90] of boolean;
    procedure CheckMaps;
    procedure DrawWorld;
    procedure DrawMaps;
    procedure SelectPart(XNr,YNr:integer);
    procedure DrawPart;
    procedure UpdateBufs;
  public
    procedure CreateParams(var Params: TCreateParams); override;
    procedure Reload;
    { Public-Deklarationen }
  end;

var
  fmBrowser: TfmBrowser;

implementation

uses uOptions, uViewMain;

{$R *.DFM}

procedure RenderWorld(Left,Top,Right,Bot:integer;C:TCanvas; W,H:integer;Wrl:TMetafile);
var hs,vs,hz,vz:single;
    rs:TRect;
    rw,rh:integer;
begin
  Left:= Left+180;
  Right:= Right+180;
  Top:= 90-Top;
  Bot:= 90-Bot;
  rw:= Right-Left;
  rh:= Bot-Top;

  hs:= wrl.Width  /W/ (Wrl.Width/360);
  vs:= wrl.Height /H/ (Wrl.Height/180);
  hz:= W/rw;
  vz:= H/rh;
  rs:= Bounds(round(-Left*hz),
              round(-top *vz),
              round(rw*hs*hz*hz),
              round(rh*vs*vz*vz));
  c.FillRect(Bounds(0,0,w,h));
  C.StretchDraw(rs,Wrl);
end;

procedure TfmBrowser.CreateParams(var Params: TCreateParams);
begin
  inherited;
  Params.WndParent:= GetDesktopWindow;
  Params.Caption:= Pchar(Caption);
end;

procedure TfmBrowser.DrawWorld;
var r:TResourceStream;

  procedure VLine(X:integer);
  begin
    with IntWrl.Canvas do begin
      MoveTo(X,0); LineTo(X,IntWrl.Height);
    end;
  end;

  procedure HLine(Y:integer);
  begin
    with IntWrl.Canvas do begin
      MoveTo(0,Y); LineTo(IntWrl.Width,Y);
    end;
  end;

var i:integer;
begin
  r:= TResourceStream.Create(HINSTANCE,'WORLD_COAST','WMF');
  try
    World.LoadFromStream(r);
    RenderWorld(-180,90,180,-90,IntWrl.Canvas,360,180,World);
  finally
    r.Free;
  end;

  IntWrl.Canvas.pen.Color:= clLtGray;
  for i:= 1 to 180 div 30 do
    HLine(30*i);
  for i:= 1 to 360 div 30 do
    VLine(30*i);
end;

procedure TfmBrowser.CheckMaps;
var sr:TSearchRec;
  coords:TCoordinates;
     p:TGeoPoint;
begin
  FillChar(Avail,sizeof(avail),0);

  if FindFirst(Options.ZipPath+'*.hgt.zip',faAnyFile,sr)=0 then
  repeat
    coords.ParseSRTMName(sr.Name);
    p:= coords.GetGeoPos;
    Avail[round(p.lon),round(p.lat)]:= true;
  until FindNext(sr)<>0;
  findClose(sr);
end;

procedure TfmBrowser.DrawMaps;
var i,j:integer;
begin
  for i:= 0 to 360 do
    for j:= 0 to 180 do
      if Avail[i-180,j-90] then
        IntWrl.Canvas.Pixels[i,180-j]:= clGreen;
end;

procedure TfmBrowser.DrawPart;
var i,j:integer;
    ra:single;
    c:TColor;
    x,y:integer;
begin
//MTop:= 90-YNr*30;
//MLeft:=XNr*30-180;
  RenderWorld(MLeft,MTop,
              MLeft+30,MTop-30,IntPar.Canvas,360,360,World);

  ra:= 360/30;

  for i:= MLeft to MLeft+30 do
    for j:= MTop-30 to MTop do begin
      if not Avail[i,j] then continue;
      if (i=curr.GetGeoPos.Lon) and
         (j=curr.GetGeoPos.Lat) then
        c:= clBlue
      else
        c:= clGreen;
      X:=round((i-MLeft)*ra);
      Y:=round((MTop-j-1)*ra);
      with IntPar.Canvas do begin
        Brush.Style:= bsClear;
        Pen.Color:= c;
        Ellipse(round(X),
                round(Y),
                round(X+ra),
                round(Y+ra));
        Brush.Style:= bsSolid;
      end;
    end;
  UpdateBufs;
end;

procedure TfmBrowser.SelectPart(XNr,YNr:integer);
begin
  MTop:= 90-YNr*30;
  MLeft:=XNr*30-180;
  DrawPart;
end;

procedure TfmBrowser.Reload;
begin
  CheckMaps;
  DrawWorld;
  DrawMaps;
  DrawPart;
  UpdateBufs;
end;

procedure TfmBrowser.FormCreate(Sender: TObject);
begin
  World:= TMetafile.Create;
  IntWrl:= TBitmap.Create;
  IntWrl.Width:= imWorld.Width;
  IntWrl.Height:= imWorld.Height;
  IntPar:= TBitmap.Create;
  IntPar.Width:= imPart.Width;
  IntPar.Height:= imPart.Height;
  btnReload.Click;
end;

procedure TfmBrowser.FormDestroy(Sender: TObject);
begin
  World.Free;
  IntWrl.Free;
  IntPar.Free;
end;

procedure TfmBrowser.btnReloadClick(Sender: TObject);
begin
  Options.ZipPath:= AppendBackSlash(Options.ZipPath);
  Reload;
end;

procedure TfmBrowser.UpdateBufs;
begin
  imWorld.Canvas.Draw(0,0,IntWrl);
  imPart.Canvas.Draw(0,0,IntPar);
end;

procedure TfmBrowser.btnOpenClick(Sender: TObject);
begin
  if not FileExists(Options.ZipPath+lbName.caption+'.hgt.zip') then exit;
  fmView.Show;
  fmView.LoadFile(Options.ZipPath+lbName.caption+'.hgt.zip');
end;

procedure TfmBrowser.FormActivate(Sender: TObject);
begin
  BringToFront;
end;

procedure TfmBrowser.imWorldMouseDown(Sender: TObject;
  Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
var ACol,ARow:integer;
begin
  ACol:= X div 30;
  ARow:= Y div 30;
  SelectPart(ACol,ARow);
end;

procedure TfmBrowser.imPartMouseDown(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
var ACol,ARow:integer;
begin
  ACol:= X div 12;
  ARow:= Y div 12;

  curr.SetOrigin(0,0);
  curr.SetGeoPos(MTop-ARow-1,MLeft+ACol);
  lbName.Caption:= curr.GetSTRMName;
  DrawPart;
  Res:= 64;
  btnPreview.Click;
end;

procedure TfmBrowser.imPartMouseMove(Sender: TObject; Shift: TShiftState;
  X, Y: Integer);
var ACol,ARow:integer;
    c:TCoordinates;
begin
  ACol:= X div 12;
  ARow:= Y div 12;

  c.SetOrigin(0,0);
  c.SetGeoPos(MTop-ARow-1,MLeft+ACol);
  lbCurr.Caption:= c.GetSTRMName;
end;

procedure TfmBrowser.btnPreviewClick(Sender: TObject);
begin
  If Res<=256 then
    Res:= Res*2;
  if not FileExists(Options.ZipPath+lbName.caption+'.hgt.zip') then exit;
  with TTopoView.Create do try
    Screen.Cursor:= crAppStart;
    fmView.AbUnZip.FileName:= Options.ZipPath+lbName.caption+'.hgt.zip';
    fmView.AbUnZip.BaseDirectory:= GetTempDir;
    fmView.AbUnZip.ExtractFiles('*.hgt');
    LoadFromFile(GetTempDir+lbName.caption+'.hgt');
    GradientHeight:= Options.GradientHeight;
    Resolution:= Res;
    GenerateTexture;
    Image1.Picture.Bitmap:= Texture;
    DeleteFile(GetTempDir+lbName.caption+'.hgt');
  finally
    Free;
    Screen.Cursor:= crDefault;
  end;
end;

end.
