unit uViewMain;

interface

uses                                 
  Windows,  Messages,  SysUtils,  Classes,  Graphics,  Controls,  Forms,  Dialogs,
  ExtCtrls, StdCtrls, ComCtrls,
  uSRTM, GLHelper, uUtils, Buttons, AbBase, AbBrowse, AbZBrows, AbUnzper, ActnList, Menus,
  ToolWin,FileInfo;

type
  TfmView = class(TForm)
    PanelDraw: TPanel;
    odHgt: TOpenDialog;
    AbUnZip: TAbUnZipper;
    pnControl2: TPanel;
    tbVertScale: TTrackBar;
    sbInfo: TSpeedButton;
    StatusBar: TStatusBar;
    tbSeaLevel: TTrackBar;
    sbSetSea: TSpeedButton;
    lbSeaLevel: TLabel;
    SaveDialog: TSaveDialog;
    ProgressBar: TProgressBar;
    ActionList1: TActionList;
    MainMenu1: TMainMenu;
    acLoadFile: TAction;
    acSaveHM: TAction;
    acSaveScreen: TAction;
    acSaveTexture: TAction;
    File1: TMenuItem;
    LoadFile1: TMenuItem;
    N1: TMenuItem;
    SaveHeightmap1: TMenuItem;
    SaveHeightmap2: TMenuItem;
    SaveTexture1: TMenuItem;
    acExit: TAction;
    Exit1: TMenuItem;
    pnControl1: TToolBar;
    ToolButton1: TToolButton;
    ToolButton2: TToolButton;
    ToolButton3: TToolButton;
    ToolButton4: TToolButton;
    acReloadOptions: TAction;
    N3: TMenuItem;
    ReloadOptions1: TMenuItem;
    acGLInfo: TAction;
    acAboutSRTM: TAction;
    Info1: TMenuItem;
    OpenGLInfo1: TMenuItem;
    AboutSRTMView1: TMenuItem;
    Options1: TMenuItem;
    acShowOptDialog: TAction;
    Options2: TMenuItem;
    acSaveOptions: TAction;
    SaveOptions1: TMenuItem;
    acPlaces: TAction;
    N2: TMenuItem;
    PlacemarksClasses1: TMenuItem;
    acBrowser: TAction;
    N4: TMenuItem;
    Browser1: TMenuItem;
    ToolButton5: TToolButton;
    ToolButton6: TToolButton;
    procedure FormCreate(Sender: TObject);
    procedure PanelDrawMouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure PanelDrawMouseMove(Sender: TObject; Shift: TShiftState; X,
      Y: Integer);
    procedure PanelDrawMouseUp(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure sbInfoClick(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure FormKeyDown(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure tbVertScaleChange(Sender: TObject);
    procedure tbSeaLevelChange(Sender: TObject);
    procedure sbSetSeaClick(Sender: TObject);
    procedure FormResize(Sender: TObject);
    procedure acLoadFileExecute(Sender: TObject);
    procedure acSaveHMExecute(Sender: TObject);
    procedure acSaveTextureExecute(Sender: TObject);
    procedure acSaveScreenExecute(Sender: TObject);
    procedure acExitExecute(Sender: TObject);
    procedure acReloadOptionsExecute(Sender: TObject);
    procedure acAboutSRTMExecute(Sender: TObject);
    procedure acGLInfoExecute(Sender: TObject);
    procedure acShowOptDialogExecute(Sender: TObject);
    procedure acSaveOptionsExecute(Sender: TObject);
    procedure acPlacesExecute(Sender: TObject);
    procedure acGLInfoUpdate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure acBrowserExecute(Sender: TObject);
  private
    FPS_measure,
    FrmDraw_measure: Int64;
    FPS, AvgFPS: single;
    Frames,
    LoadTime,
    Mx,My:integer;
    Mc:boolean;
    pressed:set of  TMouseButton;
    CurrentFile:string;
    ML,CL:TStringList;

    procedure SRTMProgress(Sender:TObject; PercentDone:byte);

    procedure LoadMarkersInt;
    procedure SaveMarkersInt;
    procedure LoadMarkers;
    procedure SaveMarkers;
    procedure ApplyOptions(Destroy: boolean);
    { Private-Deklarationen }
    procedure AppIdle(Sender:TObject; var Done:boolean);
  public
    srtm  : TTopoView;
    procedure LoadFile(fn: string);
    { Public-Deklarationen }
  end;

var
  fmView        : TfmView;



implementation

uses uControls, uOptions, Math, uGLInfo,uPlaces, uBrowser, uAbout;


resourcestring
      sCantLoadPlaces='Error reading Places.';

{$R *.dfm}

function iif(C:boolean; T,F:Variant):Variant;
begin if C then Result:= T else Result:= F; end;

type TCharSet=set of char;

function FetchToken(var s : string; delim : TCharSet) : string;
var i : integer;
    L : integer;
begin
  L := Length(s);
  Result := '';
  i := 1;
  while (i <= L) and not (s[i] in delim) do
  begin
    Result := Result + s[i];
    Inc(I);
  end;
  // skip delims
  while (i <= L) and (s[i] in delim) do
    Inc(i);
  s := Copy(s, i, L-i+1);
end;

function TextureFile(fn:string):string;
begin
  Result:= ChangeFileExt(fn,'_terrain.bmp');
end;

procedure TfmView.LoadFile(fn:string);
var del:boolean;
    s:cardinal;
//    c:TCursor;
begin
  del:= false;
  s:= GetTickCount;
  CurrentFile:= fn;
  if (CompareText(ExtractFileExt(fn), '.zip') = 0) then begin
    AbUnZip.FileName:= fn;
    AbUnZip.BaseDirectory:= GetTempDir;
    AbUnZip.ExtractFiles('*.hgt');
    fn:= GetTempDir+ExtractFileName(ChangeFileExt(fn,''));
    del:= true;
  end;
//  c:= Screen.Cursor;
//  Screen.Cursor:= crHourglass;
  try
    srtm.LoadFromFile(fn,false);
    srtm.Resolution:= Options.Resolution;
    srtm.GradientHeight:= Options.GradientHeight;
    if (CompareText(ExtractFileExt(fn), '.bmp') = 0) and
       (Fileexists(TextureFile(fn))) then begin
      srtm.Texture.LoadFromFile(ChangeFileExt(fn,'_terrain.bmp'));
    end else
      srtm.GenerateTexture;
    srtm.UpdateTexture;
    srtm.MakeVertex(Options.VertexSize);
    if del then DeleteFile(fn);
    LoadTime:= GetTickCount-s;
    srtm.ResetPos;
    fmControls.HikeY:= srtm.Highest*Height_Scale;
  finally
//    Screen.Cursor:= c;
  end;
end;


procedure TfmView.AppIdle(Sender: TObject; var Done: boolean);
var x:double;
    p:Tpoint;
begin
  Done:= false;

  if PCStop(FrmDraw_measure)<(1000/Options.FrameTarget) then exit;
  FrmDraw_measure:= PCStart;

  if srtm.Loaded then begin
    srtm.Distance:= fmControls.Dist;
    srtm.Hiking:= fmControls.Hiking;
    srtm.VertScale:= -(tbVertScale.Position/10);
    srtm.Pitch:= fmControls.Pitch;
    if srtm.Hiking then begin
      srtm.CenterX:= fmControls.HikeX;
      srtm.CenterY:= fmControls.HikeY;
      srtm.CenterZ:= fmControls.HikeZ;
      srtm.Turn   := fmControls.HikeR;
    end else begin
      srtm.CenterX  := fmControls.TransX;
      srtm.CenterZ  := fmControls.TransZ;
      srtm.Turn     := fmControls.Turn;
    end;

    srtm.DrawGL;

    with srtm.Coordinates do
      StatusBar.Panels[StatusBar.Panels.Count-1].Text:=
        Format('%s: %.1f m',[FormatGeoPoint(GetGeoPos),
                             srtm.GetHeightMapHeight(getVertex.X,getVertex.Z)/Height_Scale]);
    p:= PanelDraw.ScreenToClient(Mouse.CursorPos);
    with srtm.GetMousePos(p.x,p.y) do
      StatusBar.Panels[StatusBar.Panels.Count-2].Text:=
        Format('%s: %.1f m',[FormatGeoPoint(GetGeoPos),
                             srtm.GetHeightMapHeight(getVertex.X,getVertex.Z)/Height_Scale]);
  end else sleep(5);

  inc(Frames);
  if PCStop(FPS_Measure)>=1000 then begin
    FPS:= Frames*1000/PCStop(FPS_Measure);
    x:= Sqrt(FPS*AvgFPS);

    if x=0 then x:= FPS;
    if x=0 then x:= 1;

    AvgFPS:= x;
    Caption := 'SRTM Viewer - FPS : '+FloatToStrF(AvgFPS,ffFixed,3,0);
    FPS_measure:= PCStart;
    Frames := 0;
  end;
end;

procedure TfmView.LoadMarkersInt;
var i:integer;
    p:TGeoPoint;
    s,x,c,z,n,
    r,g,b:string;
begin
  srtm.ClearMarkers;
  for i:= 0 to ML.Count-1 do begin
    s:= ML[i];
    if (length(s)=0) or(s[1]in['/','#']) then continue;
    n:= ML.Names[i];
    s:= trim(ML.Values[n]);
    x:= FetchToken(s,[',',' ']);
    z:= FetchToken(s,[',',' ']);
    c:= FetchToken(s,[',',' ']);
    try
      p:= GeoPoint(StrToFloat(x),StrToFloat(z));

      srtm.AddMarker(p,trim(n), StrToIntdef(c,0));
    except
    end;
  end;
  srtm.ClearClasses;
  for i:= 0 to CL.Count-1 do begin
    s:= CL[i];
    if (length(s)=0) or(s[1]in['/','#']) then continue;
    c:= CL.Names[i];
    s:= trim(CL.Values[c]);
    r:= FetchToken(s,[',',' ']);
    g:= FetchToken(s,[',',' ']);
    b:= FetchToken(s,[',',' ']);
    n:= s;
    c:= trim(c);
    try
      srtm.AddClass(StrToIntDef(c,0),n,StrToFloat(r),StrToFloat(g),StrToFloat(b));
    except
    end;
  end;
end;

procedure TfmView.SaveMarkersInt;
var li:TList;
    i:integer;
    m:TMarkerObject;
    mc:TMarkerClass;
begin
  CL.Clear;
  li:= srtm.GetClassList;
  for i:= 0 to li.Count-1 do begin
    mc:= PMarkerClass(li[i])^;
    CL.Add(format('%-5d=%-3s,%-3s,%-3s,%s',[mc.ID,FloatToStr(Mc.r),FloatToStr(Mc.g),FloatToStr(Mc.b),mc.Name]));
  end;

  ML.Clear;
  li:= srtm.GetMarkerList;
  for i:= 0 to li.Count-1 do begin
    m:= PMarkerObject(li[i])^;
    ML.Add(format('%-40s=%-12s,%-12s,%d',[m.Name,FloatToStr(M.Pos.Lon),FloatToStr(M.Pos.Lat),m.MClass]));
  end; 
end;

procedure TfmView.LoadMarkers;
begin
  Options.GetSection('Places',ML);
  Options.GetSection('MClasses',CL);
  LoadMarkersInt;
end;

procedure TfmView.SaveMarkers;
begin
  SaveMarkersInt;
  Options.PutSection('Places',ML);
  Options.PutSection('MClasses',CL);
end;

procedure TfmView.ApplyOptions(Destroy:boolean);
var s2:string;
begin
  if assigned(srtm) then begin
    if srtm.Loaded then
      s2:= CurrentFile
    else
      s2:= '';
    if Destroy then srtm.Free else exit;
  end;

  case Options.TopoClass of
    0: srtm:= TTopoViewCLOD.Create;
    1: srtm:= TTopoViewVBO.Create;
    2: srtm:= TTopoView.Create;
  end;

  srtm.OnProgress:= SRTMProgress;
  SRTMProgress(self,0);
  srtm.DrawPanel:= PanelDraw;
  srtm.Background:= Options.Background;
  tbVertScale.Position:= -Round(Options.VerticalScale*10);
  tbSeaLevelChange(self);
  srtm.InitGL;
  if srtm is TTopoViewCLOD then begin
    TTopoViewCLOD(srtm).kleinC:= options.CLODsmC;
    TTopoViewCLOD(srtm).C:= options.CLODC;
  end;
  if (s2>'') and FileExists(s2) then LoadFile(s2);
  if fmBrowser<>nil then
    fmBrowser.Reload;
end;

procedure TfmView.FormCreate(Sender: TObject);
begin
  Application.Title:= Caption;
  Application.OnIdle:= AppIdle;
  CL:= TStringList.Create;
  ML:= TStringList.Create;
  srtm:= nil;
  Options.Init;
  ApplyOptions(true);
  LoadMarkers;
  FPS_measure:= PCStart;
  FrmDraw_measure:= PCStart;
end;

procedure TfmView.FormDestroy(Sender: TObject);
begin
  CL.Free;
  ML.Free;
  Srtm.Free;
end;

procedure TfmView.PanelDrawMouseDown(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
begin
  MX:= x;
  My:= y;
  MC:= true;
  include(pressed,Button);
end;

procedure TfmView.PanelDrawMouseMove(Sender: TObject; Shift: TShiftState;
  X, Y: Integer);
begin
  with fmControls do begin
    if mc then begin
      if pressed=[mbRight] then begin
        Turn := Turn - ((MX - X) div 2);
        Pitch:= Pitch   - ((MY - Y) div 2);
      end;
      if pressed=[mbLeft] then begin
        BewegLinksRechts(X - MX);
        BewegVorZuruck  (Y - MY);
      end;
      if pressed=[mbRight,mbLeft] then begin
        Dist := Dist   - ((MY - Y) div 2);
      end;
      MX:= x;
      My:= y;
    end;
  end;
end;

procedure TfmView.PanelDrawMouseUp(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
begin
  mc:= False;
  Exclude(pressed,Button);
end;

procedure TfmView.sbInfoClick(Sender: TObject);
var s:string;
begin
  s:= 'Status:'+#13+
      'Version: %s'+#13+
      iif(srtm is TTopoViewVBO,'VBuffersize in KB: %.0n'+#13,'')+
      'Last Loading Time: %f sec'+#13+
      'Frames per Second: %.1f'+#13#13#13+
      'Usage:'+#13+
      'RMB + Move Up/Down  = Rotate Vertical'+#13+
      'RMB + Move Left/Right  = Rotate Horizontal'+#13+
      'LMB + RMB + Move Up/Down  = Zoom In/Out'+#13+
      'Hiking Mode:'+#13+
      'RMB + Move Up/Down   = Look Up/Down';
  if srtm is TTopoViewVBO then
    s:= Format(s,[GetFileVersion,TTopoViewVBO(srtm).VBufCount/1024,LoadTime / 1000,FPS])
  else
    s:= Format(s,[GetFileVersion,LoadTime / 1000,FPS]);
  MessageDlg(s,mtInformation,[mbOk],0);
end;

procedure TfmView.FormShow(Sender: TObject);
begin
  fmControls.Show;
  fmControls.Left:= BoundsRect.Right-fmControls.Width;
  fmControls.Top := pnControl1.BoundsRect.Bottom;
  Options.Changed;
  FormResize(sender);
  fmBrowser.Show;
end;

procedure TfmView.FormKeyDown(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
  fmControls.FormKeyDown(Sender,Key,Shift);
  case key of
    ord('W'): Srtm.WireFrame:= not Srtm.WireFrame;
  end;
end;

procedure TfmView.tbVertScaleChange(Sender: TObject);
begin
  HintSlider(tbVertScale,-(tbVertScale.Position/10));
end;

procedure TfmView.tbSeaLevelChange(Sender: TObject);
begin
  HintSlider(tbSeaLevel,-(tbSeaLevel.Position));
  lbSeaLevel.Caption:= IntToStr(-tbSeaLevel.Position);
end;

procedure TfmView.sbSetSeaClick(Sender: TObject);
begin
  srtm.SetSeaLevel(-tbSeaLevel.Position);
end;

procedure TfmView.FormResize(Sender: TObject);
var i,x:integer;
begin
  x:= 0;
  for i:= 1 to StatusBar.Panels.Count-1 do
    x:= x+StatusBar.Panels[i].Width+2;
  StatusBar.Panels[0].Width:= StatusBar.ClientWidth-x;
  ProgressBar.Width:= StatusBar.Panels[0].Width;
  ProgressBar.Height:= StatusBar.ClientHeight-2;
end;

procedure TfmView.SRTMProgress(Sender: TObject; PercentDone: byte);
begin
  if PercentDone=0 then begin
    ProgressBar.Parent:= StatusBar;
    ProgressBar.Top:= 2;
    ProgressBar.Left:= 0;
    ProgressBar.Visible:= true;
    if sender<> self then
      Screen.Cursor:= crHourGlass;
  end;
  if PercentDone=100 then begin
    ProgressBar.Visible:= false;
    Screen.Cursor:= crDefault;
    StatusBar.Panels[1].Text:= '';
  end;
  ProgressBar.Position:= PercentDone;
end;

procedure TfmView.acLoadFileExecute(Sender: TObject);
begin
  if odHgt.Execute then
    LoadFile(odHgt.FileName);
end;

procedure TfmView.acSaveHMExecute(Sender: TObject);
begin
  SaveDialog.Filter:= 'Heightmap & Texture(*.bmp)|*.bmp|Heightmap only(*.bmp)|*.bmp';
  SaveDialog.DefaultExt:= 'bmp';
  SaveDialog.FilterIndex:=1;
  if SaveDialog.Execute then begin
    srtm.SaveHeightMap(SaveDialog.FileName);
    if SaveDialog.FilterIndex=0 then
      srtm.SaveTexture(TextureFile(SaveDialog.FileName));
  end;
end;

procedure TfmView.acSaveTextureExecute(Sender: TObject);
begin
  SaveDialog.Filter:= 'Texture(*.bmp)|*.bmp|Texture(*.jpg)|*.jpg|Texture(*.tga)|*.tga';
  SaveDialog.DefaultExt:= 'jpg';
  SaveDialog.FilterIndex:=1;
  if SaveDialog.Execute then begin
    srtm.SaveTexture(SaveDialog.FileName);
  end;
end;

procedure TfmView.acSaveScreenExecute(Sender: TObject);
begin
  SaveDialog.Filter:= 'Windows Bitmap(*.bmp)|*.bmp|JPEG(*.jpg)|*.jpg|Truevision Targa(*.tga)|*.tga';
  SaveDialog.DefaultExt:= 'jpg';
  SaveDialog.FilterIndex:=1;
  if SaveDialog.Execute then begin
    srtm.SaveScreen(SaveDialog.FileName);
  end;
end;

procedure TfmView.acExitExecute(Sender: TObject);
begin
  Close;
end;

procedure TfmView.acReloadOptionsExecute(Sender: TObject);
begin
  Options.Init;
  ApplyOptions(true);
  LoadMarkers;
end;

procedure TfmView.acAboutSRTMExecute(Sender: TObject);
begin
  with TfmAbout.Create(Application) do try
    Showmodal;
  finally
    Release;
  end;
end;

procedure TfmView.acGLInfoExecute(Sender: TObject);
begin
  with TfmGLInfo.Create(Application) do try
    DC:= srtm.GetDC;
    RC:= srtm.GetRC;
    ShowModal;
  finally
    Release;
  end;
end;

procedure TfmView.acGLInfoUpdate(Sender: TObject);
begin
  acGLInfo.Enabled:= assigned(srtm);
end;

procedure TfmView.acShowOptDialogExecute(Sender: TObject);
begin
  SaveMarkersInt;
  if Options.ShowSetup then ApplyOptions(true);
  LoadMarkersInt;
end;

procedure TfmView.acSaveOptionsExecute(Sender: TObject);
begin
  Options.Write;
  SaveMarkers;
end;

procedure TfmView.acPlacesExecute(Sender: TObject);
var i,j:integer;
    l:TList;
    m:TMarkerObject;
    mc:TMarkerClass;
    p:TGeoPoint;
    c:TColor;
    rgb:TRGBA;
begin
  with TfmPlaces.Create(Application) do try
    l:= srtm.GetMarkerList;
    for i:= 0 to l.Count-1 do begin
      m:= PMarkerObject(l[i])^;
      AddRow(sgPlaces,[m.Name,FloatToStr(M.Pos.Lon),FloatToStr(M.Pos.Lat),IntToStr(m.MClass)]);
    end;
    l:= srtm.GetClassList;
    for i:= 0 to l.Count-1 do begin
      mc:= PMarkerClass(l[i])^;
      with mc do
        AddRow(sgClasses,[IntToStr(ord(Visible)),Inttostr(ID),Name,
                          '$'+IntToHex(RGBToColor(r,g,b),8)]);
    end;
    if ShowModal=mrOK then begin
      srtm.ClearMarkers;
      for i:= 1 to sgPlaces.RowCount-1 do begin
        if GridRowEmpty(sgPlaces,i) then continue;
        sgPlaces.row:= i;
        p:= GeoPoint(StrToFloat(GetString(sgPlaces,1)),StrToFloat(GetString(sgPlaces,2)));

        srtm.AddMarker(p,GetString(sgPlaces,0), StrToIntdef(GetString(sgPlaces,3),0));
      end;
      srtm.ClearClasses;
      for i:= 1 to sgClasses.RowCount-1 do begin
        if GridRowEmpty(sgClasses,i) then continue;
        sgClasses.row:= i;
        c:= StrToInt(GetString(sgClasses,3));
        rgb:= ColorToRGBA(c);
        j:= StrToInt(GetString(sgClasses,1));
        srtm.AddClass(j, GetString(sgClasses,2),rgb.r,rgb.g,rgb.b);
        srtm.ClassVis(j, StrToInt(GetString(sgClasses,0))=1);
      end;
    end;
  finally
    Release;
  end;
end;

procedure TfmView.acBrowserExecute(Sender: TObject);
begin
  fmBrowser.Show;
end;

end.
 