unit uOptions;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  IniFiles, ComCtrls, StdCtrls, ExtCtrls, Mask, ToolEdit;

type
  TfmOptions = class(TForm)
    pcOptions: TPageControl;
    tsGeneral: TTabSheet;
    tsDisplay: TTabSheet;
    tsScene: TTabSheet;
    ofTopoClass: TComboBox;
    Label1: TLabel;
    ofVertexSize: TTrackBar;
    Label2: TLabel;
    ofFrameTarget: TTrackBar;
    Label3: TLabel;
    Label4: TLabel;
    Label5: TLabel;
    ofBackColor: TPanel;
    ofGradient: TCheckBox;
    GroupBox1: TGroupBox;
    Label6: TLabel;
    ofSmallC: TTrackBar;
    ofC: TTrackBar;
    Label7: TLabel;
    Button1: TButton;
    Button2: TButton;
    ColorDialog: TColorDialog;
    ofResolution: TComboBox;
    ofZipPath: TDirectoryEdit;
    Label8: TLabel;
    procedure ofSliderChange(Sender: TObject);
    procedure ofSlider2Change(Sender: TObject);
    procedure ofBackColorDblClick(Sender: TObject);
  private
    { Private-Deklarationen }
  public
    { Public-Deklarationen }
  end;

  TOptionRec = object
  private
    MyIni:TMemIniFile;
  public
    VertexSize,
    Resolution: integer;
    VerticalScale:single;
    Background:TColor;
    GradientHeight:Boolean;
    TopoClass:integer;
    FrameTarget:integer;
    CLODsmC,CLODC:Single;

    ZipPath:string;
    function ShowSetup:boolean;
    procedure Init;
    procedure Write;
    procedure Changed;
    procedure GetSection(Section:string; List:TStringList);
    procedure PutSection(Section: string; List: TStringList);
  end;

var
  Options:TOptionRec;

procedure HintSlider(Slider:TTrackBar; Val:double=MaxInt);


resourcestring
  sCurrIs = 'Current Value:';

implementation

{$R *.DFM}

uses uControls, uSRTM, uUtils;

procedure HintSlider(Slider:TTrackBar; Val:double=MaxInt);
var s:string;
begin
  s:= Slider.Hint;
  if LastDelimiter(#13,s)>0 then
    delete(s,LastDelimiter(#13,s),1000);
  if Val=MaxInt then
    Val:= Slider.Position;
  s:= format('%s %.1f',[s+#13+sCurrIs,Val]);
  Slider.Hint:= s;
end;

{ TOptionRec }

procedure TOptionRec.Changed;
begin
  if Assigned(fmControls) then begin
    fmControls.tbTransX.Min:= -VertexSize div 2;
    fmControls.tbTransX.Max:=  VertexSize div 2;
    fmControls.tbTransZ.Min:= -VertexSize div 2;
    fmControls.tbTransZ.Max:=  VertexSize div 2;
  end;
  ZipPath:= AppendBackSlash(ZipPath);
end;

procedure TOptionRec.GetSection(Section: string; List: TStringList);

begin
  if Section='' then exit;
  with MyIni do begin
    List.Clear;
    ReadSectionValues(Section,List);
  end;         
end;

procedure TOptionRec.PutSection(Section: string; List: TStringList);
var i:integer;
begin
  if Section='' then exit;
  with MyIni do begin
    for i:= 0 to List.Count-1 do
      WriteString(Section,List.Names[i],List.Values[List.Names[i]]);   
  end;
end;

procedure TOptionRec.Init;
begin
  MyIni:= TMemIniFile.Create(ChangeFileExt(ParamStr(0),'.ini'));
  with MyIni do begin
    TopoClass     := ReadInteger('General','TopoClass',0);
    VertexSize    := ReadInteger('General.Display','VertexSize', 128);
    VerticalScale := StrToFloat(ReadString('General.Display','VerticalScale', '1.0'));
    FrameTarget   := ReadInteger('General.Display','FrameTarget',50);
    Resolution    := ReadInteger('General.Scene','Resolution', 768);
    Background    := ReadInteger('General.Scene','BackColor', $00FFEAB0);
    GradientHeight:= ReadBool(   'General.Scene','Gradient', false);
    CLODsmC       := StrToFloat(ReadString('General.CLOD','smallC','0.8'));
    CLODC         := StrToFloat(ReadString('General.CLOD','C','4.0'));

    ZipPath       := ReadString('Browser','ZipPath',ExtractFilePath(ParamStr(0)));
    ZipPath       := ExpandDirectory(ExtractFilePath(ParamStr(0)),ZipPath);
    if ZipPath[length(ZipPath)]<>'\' then ZipPath:= ZipPath+'\';
  end;
  Changed;
end;


procedure TOptionRec.Write;
begin
  with MyIni do begin
    WriteInteger('General','TopoClass',TopoClass);
    WriteInteger('General.Display','VertexSize', VertexSize);
    WriteString('General.Display','VerticalScale', FloatToStr(VerticalScale));
    WriteInteger('General.Display','FrameTarget',FrameTarget);
    WriteInteger('General.Scene','Resolution', Resolution);
    WriteString('General.Scene','BackColor', '$'+IntToHex(Background,8));
    WriteBool('General.Scene','Gradient', GradientHeight);
    WriteString('General.CLOD','smallC',FloatToStr(CLODsmC));
    WriteString('General.CLOD','C',FloatToStr(CLODC));
    WriteString('Browser','ZipPath',ZipPath);
    UpdateFile;
  end;
end;

function TOptionRec.ShowSetup:boolean;
begin
  with TfmOptions.Create(Application) do try
    ofTopoClass.ItemIndex:= TopoClass;
    ofVertexSize.Position:= VertexSize;
    ofFrameTarget.Position:= FrameTarget;
    ofResolution.Text:= IntToStr(Resolution);
    ofBackColor.Color:= Background;
    ofGradient.Checked:= GradientHeight;
    ofSmallC.Position:= round(CLODsmC*10);
    ofC.Position:=  round(CLODC*10);
    ofZipPath.Text:= ZipPath;
    pcOptions.ActivePage:= pcOptions.Pages[0];
    Result:= ShowModal=mrOk;
    if Result then begin
      TopoClass:= ofTopoClass.ItemIndex;
      VertexSize:= ofVertexSize.Position;
      FrameTarget:= ofFrameTarget.Position;
      Resolution:= StrToInt(ofResolution.Text);
      Background:= ofBackColor.Color;
      GradientHeight:= ofGradient.Checked;
      CLODsmC:= ofSmallC.Position/10;
      CLODC:= ofC.Position/10;
      ZipPath:= ofZipPath.Text;
      Changed;
    end;
  finally
    Release;
  end;
end;

procedure TfmOptions.ofSliderChange(Sender: TObject);
begin
  if Sender is TTrackBar then
    HintSlider(Sender as TTrackBar);
end;

procedure TfmOptions.ofSlider2Change(Sender: TObject);
begin
  if Sender is TTrackBar then
    HintSlider(Sender as TTrackBar,(Sender as TTrackBar).Position/10);
end;

procedure TfmOptions.ofBackColorDblClick(Sender: TObject);
begin
  ColorDialog.Color:= ofBackColor.Color;
  if ColorDialog.Execute then ofBackColor.Color:= ColorDialog.Color;
end;

initialization
  Options.Init;

end.

