unit uControls;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  Buttons, ComCtrls, ExtCtrls, StdCtrls, uUtils;

const
  BewegFaktor=0.2;
type
  TfmControls = class(TForm)
    Notebook1: TNotebook;
    tbAngle: TTrackBar;
    tbViewPos: TTrackBar;
    sbRotate: TSpeedButton;
    btnViewTop: TSpeedButton;
    sbViewStandard: TSpeedButton;
    cbHiking: TCheckBox;
    sbForward: TSpeedButton;
    sbRight: TSpeedButton;
    sbLeft: TSpeedButton;
    sbStop: TSpeedButton;
    sbBack: TSpeedButton;
    tmrRot: TTimer;
    sbDown: TSpeedButton;
    sbUp: TSpeedButton;
    sbReset: TSpeedButton;
    tbTransX: TTrackBar;
    tbTransZ: TTrackBar;
    tbSpeed: TTrackBar;
    sbStopUpDn: TSpeedButton;
    tbDist: TTrackBar;
    procedure sbViewStandardClick(Sender: TObject);
    procedure btnViewTopClick(Sender: TObject);
    procedure cbHikingClick(Sender: TObject);
    procedure sbForwardClick(Sender: TObject);
    procedure sbBackClick(Sender: TObject);
    procedure sbLeftClick(Sender: TObject);
    procedure sbRightClick(Sender: TObject);
    procedure tmrRotTimer(Sender: TObject);
    procedure sbStopClick(Sender: TObject);
    procedure FormKeyDown(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure sbUpClick(Sender: TObject);
    procedure sbDownClick(Sender: TObject);
    procedure sbResetClick(Sender: TObject);
    procedure tbSpeedChange(Sender: TObject);
    procedure sbStopUpDnClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure SliderChange(Sender: TObject);
  private
    { Private-Deklarationen }
    hx,hy,hz,ht,DeltaT,Step,VStep:single;
    Rot   : Single;
    function GetH: Boolean;
    procedure PutH(const Value: Boolean);
    function Get(const Index: Integer): single;
    procedure Put(const Index: Integer; const Value: single);
  public
    { Public-Deklarationen }
    property Pitch  : single  index 0 read Get  write Put;
    property Turn   : single  index 1 read Get  write Put;
    property Dist   : single  index 2 read Get  write Put;
    property Hiking : Boolean         read GetH write PutH;
    property HikeX  : single  index 3 read Get  write Put;
    property HikeZ  : single  index 4 read Get  write Put;
    property HikeR  : single  index 5 read Get  write Put;
    property HikeY  : single  index 6 read Get  write Put;
    property TransX : single  index 7 read Get  write Put;
    property TransZ : single  index 8 read Get  write Put;

    procedure BewegVorZuruck(Delta: double);
    procedure BewegLinksRechts(Delta: double);
  end;

var
  fmControls: TfmControls;


implementation

uses uViewMain, Math, uOptions;

{$R *.DFM}

procedure TfmControls.sbViewStandardClick(Sender: TObject);
begin
  Pitch:= -35;
  Turn:= 35;
  Dist:= 35;
  fmView.tbVertScale.Position:= -10;
  TransX:= 0;
  TransZ:= 0;     
end;

procedure TfmControls.btnViewTopClick(Sender: TObject);
begin
  Pitch:= -90;
  Turn:= 0;
  Dist:= 32;
  fmView.tbVertScale.Position:= 1;
  TransX:= 0;
  TransZ:= 0;
end;

procedure TfmControls.cbHikingClick(Sender: TObject);
begin
  Notebook1.PageIndex:= ord(cbHiking.Checked);
  if cbHiking.Checked then begin
    Dist:= 80;
    Pitch:= 20;
    HikeY:= fmView.srtm.OvergroundPos(HikeX,HikeZ);
  end else sbViewStandard.Click;
end;

procedure TfmControls.sbForwardClick(Sender: TObject);
begin
  Step:= Step + (tbSpeed.Position * 0.02);
end;

procedure TfmControls.sbBackClick(Sender: TObject);
begin
  Step:= Step - (tbSpeed.Position * 0.02);
end;

procedure TfmControls.sbUpClick(Sender: TObject);
begin
  VStep:= VStep + 0.03;
end;

procedure TfmControls.sbDownClick(Sender: TObject);
begin
  VStep:= VStep - 0.03;
end;

procedure TfmControls.sbLeftClick(Sender: TObject);
begin
  DeltaT:= DeltaT+0.2;
end;

procedure TfmControls.sbRightClick(Sender: TObject);
begin
  DeltaT:= DeltaT-0.2;
end;

function TfmControls.GetH: Boolean;
begin
  Result:= cbHiking.Checked;
end;

procedure TfmControls.PutH(const Value: Boolean);
begin
  cbHiking.Checked:= Value;
end;


function TfmControls.Get(const Index: Integer): single;
begin
  Result:= 0.0;
  case Index of
    0  : Result:= tbAngle.Position;
    1  : if sbRotate.Down then Result:= Rot else Result:= tbViewPos.Position;
    2  : Result:= tbDist.Position;
    3  : Result:= hx;
    4  : Result:= hz;
    5  : Result:= ht;
    6  : Result:= hy;
    7  : Result:= tbTransX.Position;
    8  : Result:= tbTransZ.Position;
  end;
end;

procedure TfmControls.Put(const Index: Integer; const Value: single);
begin
  case Index of
    0  : tbAngle.Position   := trunc(Value);
    1  : tbViewPos.Position := trunc(Value);
    2  : tbDist.Position    := trunc(Value);
    3  : hx                 := Value;
    4  : hz                 := Value;
    5  : ht                 := Value;
    6  : hy                 := Value;
    7  : tbTransX.Position  := trunc(Value);
    8  : tbTransZ.Position  := trunc(Value);
  end;
end;

procedure TfmControls.tmrRotTimer(Sender: TObject);
begin
  if sbRotate.Down then begin
    Rot := Rot+0.3;
    if Rot > 360 then
      Rot := 0;
    tbViewPos.Position:= trunc(Rot);
  end else Rot:= tbViewPos.Position;
  
  ht := ht+DeltaT;
  if ht > 360 then
    ht := 0;
  if ht < 0 then
    ht := 360;

  hx:= hx+sin(degtorad(ht))*Step;
  hz:= hz+cos(degtorad(ht))*Step;
  hy:= hy+VStep;
  Limit(DeltaT,3);
  Limit(Step,1.5);
  Limit(VStep,1.5);
end;

procedure TfmControls.sbStopClick(Sender: TObject);
begin
  DeltaT:= 0;
  Step:= 0;
  VStep:= 0;
end;

procedure TfmControls.sbStopUpDnClick(Sender: TObject);
begin       
  VStep:= 0;
end;

procedure TfmControls.FormKeyDown(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
  case Key of
    VK_NUMPAD4 : sbLeft.Click;
    VK_NUMPAD8 : sbForward.Click;
    VK_NUMPAD6 : sbRight.Click;
    VK_NUMPAD2 : sbBack.Click;
    VK_NUMPAD5 : sbStop.Click;
    VK_NUMPAD9 : sbUp.Click;
    VK_NUMPAD3 : sbDown.Click;
    VK_NUMPAD0 : sbStopUpDn.Click;
  end;
end;

procedure TfmControls.sbResetClick(Sender: TObject);
begin
  fmView.srtm.ResetPos;
  Pitch:= fmView.srtm.Pitch;
  Turn:= fmView.srtm.Turn;
  Dist:= fmView.srtm.Distance;
  fmView.tbVertScale.Position:= -10;
  DeltaT:= 0;
  Step:= 0;
  VStep:= 0;
  TransX:= 0;
  TransZ:= 0;
end;

procedure TfmControls.tbSpeedChange(Sender: TObject);
begin   //
  if Step > 0 then
    Step:= tbSpeed.Position * 0.03;
end;



procedure TfmControls.FormCreate(Sender: TObject);
begin
  Notebook1.PageIndex:=0;
  sbViewStandard.Click;
end;

procedure TfmControls.SliderChange(Sender: TObject);
begin
  if Sender is TTrackBar then
    HintSlider(TTrackBar(Sender));
end;

procedure TfmControls.BewegLinksRechts(Delta: double);
begin
  TransX:=TransX+2*BewegFaktor*Delta*cos(DegToRad(Turn));
  TransZ:=TransZ+2*BewegFaktor*Delta*sin(DegToRad(Turn));
end;

procedure TfmControls.BewegVorZuruck(Delta: double);
begin
  TransZ:=TransZ+BewegFaktor*Delta*cos(DegToRad(Turn));
  TransX:=TransX-BewegFaktor*Delta*sin(DegToRad(Turn));
end;

end.
