unit FileInfo;

interface

uses  SysUtils, Windows, Classes;

const                          { constants for GetFileInfo }
   vrCompanyName       = 1;
   vrFileDescription   = 2;
   vrFileVersion       = 3;
   vrInternalName      = 4;
   vrLegalCopyright    = 5;
   vrOriginalFilename  = 6;
   vrProductName       = 7;
   vrProductVersion    = 8;
   vrComments          = 9;
   vrFlags             = 10;


function GetFileInfo(FileName : string;InfoTyp : integer) : string;

function GetFileVersion : string;

implementation


const                      { constants for ResourceInfoStrings }
  VerResourceString : array[1..10] of string =
                     ('CompanyName',
                      'FileDescription',
                      'FileVersion',
                      'InternalName',
                      'LegalCopyright',
                      'OriginalFilename',
                      'ProductName',
                      'ProductVersion',
                      'Comments',
                      'Flags');


function GetFileInfo(FileName : string;InfoTyp : integer) : string;
var  Handle : Cardinal;
     InfoSize : Integer;
     Data : PChar;
     Buffer : Pointer;
     TransBuffer : Pointer;
     Len : Cardinal;
     CharSet : string;
     ResStr : string;

begin
  Result:='';
  if FileName='' then FileName:= ParamStr(0);
  InfoSize:=GetFileVersionInfoSize(pChar(FileName),Handle);   // Retrieve size of VersionInfo
  if InfoSize>0 then begin
    GetMem(Data,InfoSize);                                    // Get memory for info buffer
    GetFileVersionInfo(pChar(FileName),Handle,InfoSize,data); // get the complete FileVersionInfo
    if VerQueryValue(Data,'\VarFileInfo\Translation',
                    TransBuffer, Len) then      // get value for country code
    begin
      // translate country code into string
      CharSet:=IntToHex(MakeLong(HiWord(Longint(TransBuffer^)),
                                 LoWord(Longint(TransBuffer^))), 8);
      ResStr:=VerResourceString[InfoTyp];
      // Query char set depending info, the ResourceInfoString is stated by InfoTyp
      if VerQueryValue(Data,pChar('\StringFileInfo\'+CharSet+'\'+ResStr),Buffer,Len) then
        Result:= PChar(Buffer);
    end;
    FreeMem(Data); // Dispose data buffer
  end;
end;


function GetFileVersion : string;
{ ---------------------------------------------------------
   Extracts the FileVersion element of the VERSIONINFO
   structure that Delphi maintains as part of a project's
   options.

   Results are returned as a standard string.  Failure
   is reported as "".

   Note that this implementation was derived from similar
   code used by Delphi to validate ComCtl32.dll.  For
   details, see COMCTRLS.PAS, line 3541.
  -------------------------------------------------------- }
const
  NOVIDATA = '';

var
  dwInfoSize,           // Size of VERSIONINFO structure
  dwVerSize,            // Size of Version Info Data
  dwWnd: DWORD;         // Handle for the size call.
  FI: PVSFixedFileInfo; // Delphi structure; see WINDOWS.PAS
  ptrVerBuf: Pointer;   // pointer to a version buffer
  strFileName,          // Name of the file to check
  strVersion : string;  // Holds parsed version number
begin
  strFileName := paramStr( 0 );
  dwInfoSize := GetFileVersionInfoSize( pChar( strFileName ), dwWnd);

  if ( dwInfoSize = 0 ) then
    result := NOVIDATA
  else begin
    GetMem( ptrVerBuf, dwInfoSize );
    try
      if GetFileVersionInfo( pChar( strFileName ),dwWnd, dwInfoSize, ptrVerBuf ) then

        if VerQueryValue( ptrVerBuf, '\',pointer(FI), dwVerSize ) then

          strVersion := format( '%d.%d.%d.%d',
                               [ hiWord( FI.dwFileVersionMS ),
                                 loWord( FI.dwFileVersionMS ),
                                 hiWord( FI.dwFileVersionLS ),
                                 loWord( FI.dwFileVersionLS ) ] );

    finally
      FreeMem( ptrVerBuf );
    end;
  end;
  Result := strVersion;
end;

(*
procedure GetApplicationVersion(var Ver, SubVer, Release, Build: Integer);
var
  Size, Size2: DWord;
  Pt, Pt2: Pointer;
begin
 Size := GetFileVersionInfoSize(PChar(Application.ExeName), Size2);
 if Size > 0 then begin
  GetMem (Pt, Size);
  try
   GetFileVersionInfo (PChar (ParamStr (0)), 0, Size, Pt);
   VerQueryValue (Pt, '\', Pt2, Size2);
   with TVSFixedFileInfo (Pt2^) do begin
    Ver:= HiWord(dwFileVersionMS);
    SubVer:= LoWord(dwFileVersionMS);
    Release:= HiWord(dwFileVersionLS);
    Build:= LoWord(dwFileVersionLS);
   end;
  finally
   FreeMem (Pt);
  end;
 end;
end;
*)

(*

you are forcing the language to "040904E4" and it is possible that the
NT system on which you are testing is using a different language
resource. The following code (based on Borland's TI) should do it for
you:

const
  CInfoStr : array[1..10] of string =
    ('CompanyName',      'FileDescription', 'FileVersion',
     'InternalName',     'LegalCopyright',  'LegalTradeMarks',
     'OriginalFilename', 'ProductName',     'ProductVersion',
     'Comments');

var
  filename: string;
  i:        integer;
  infoSize: DWORD;
  language: string;
  noInfo:   boolean;
  ptrans:   PTransBuffer;
  transStr: string;
  typeStr:  string;
  value:    PChar;
  verBuf:   pointer;
  verSize:  DWORD;
  wnd:      DWORD;
begin
  noInfo := false;
  VersionList.Clear;
  filename := FileList.Filename;
  infoSize := GetFileVersioninfoSize(PChar(filename), wnd);

  if infoSize <> 0 then
  begin
    GetMem(verBuf, infoSize);
    try
      if GetFileVersionInfo(PChar(filename), wnd, infoSize, verBuf)
then
      begin
        VerQueryvalue(verBuf, PChar('\VarFileInfo\Translation'),
                      Pointer(ptrans), verSize);

        transStr := IntToHex(ptrans^[1], 4) + IntToHex(ptrans^[2], 4);

        for i := Low(CInfoStr) to High(CInfoStr) do
        begin
          typeStr := 'StringFileInfo\' + transStr + '\' + CInfoStr[i];

          if VerQueryvalue(verBuf, PChar(typeStr),
                           Pointer(value), verSize) then
            VersionList.Lines.Add(CInfoStr[i] + ': ' + value);
        end;

        if VersionList.Lines.Count > 0 then
        begin
          SetLength(language, 256);
          VerLanguageName(ptrans^[1], PChar(language), 256);
          SetLength(language, StrLen(PChar(language)));
          VersionList.Lines.Add('Language: ' + language);
        end;
      end
      else
        noInfo := true;
    finally
      FreeMem(verBuf);
    end;
  end
  else
    noInfo := true;

  if noInfo then
    VersionList.Lines.Add(filename + ' contains no version info.')

*)


end.
